/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.Assert;
import org.apache.giraph.utils.ProgressableUtils;
import org.apache.hadoop.util.Progressable;
import org.junit.Test;

public class TestProgressableUtils {
    @Test
    public void testProgressableUtils() throws NoSuchFieldException, IllegalAccessException {
        int sleepTime = 1800;
        int msecPeriod = 500;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1800L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException();
                }
            }
        });
        executor.shutdown();
        CountProgressable countProgressable = new CountProgressable();
        ProgressableUtils.awaitExecutorTermination((ExecutorService)executor, (Progressable)countProgressable, (int)500);
        Assert.assertTrue((countProgressable.counter >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((countProgressable.counter <= 4 ? 1 : 0) != 0);
    }

    private static class CountProgressable
    implements Progressable {
        private int counter = 0;

        private CountProgressable() {
        }

        public void progress() {
            ++this.counter;
        }
    }
}

