/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.WorkerClientRequestProcessor;
import org.apache.giraph.comm.messages.ByteArrayMessagesPerVertexStore;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.ArrayListEdges;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.GraphState;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.BasicPartitionOwner;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.SimplePartition;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockUtils {
    private MockUtils() {
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable> MockedEnvironment<I, V, E, M> prepareVertexAndComputation(Vertex<I, V, E> vertex, I vertexId, V vertexValue, boolean isHalted, Computation<I, V, E, M, M> computation, long superstep) throws Exception {
        MockedEnvironment env = new MockedEnvironment();
        Mockito.when((Object)env.getGraphState().getSuperstep()).thenReturn((Object)superstep);
        Mockito.when((Object)env.getGraphState().getContext()).thenReturn((Object)env.getContext());
        Mockito.when((Object)env.getContext().getConfiguration()).thenReturn((Object)env.getConfiguration());
        computation.initialize(env.getGraphState(), env.getWorkerClientRequestProcessor(), null, null, null);
        GiraphConfiguration giraphConf = new GiraphConfiguration();
        giraphConf.setComputationClass(computation.getClass());
        giraphConf.setOutEdgesClass(ArrayListEdges.class);
        ImmutableClassesGiraphConfiguration conf = new ImmutableClassesGiraphConfiguration((Configuration)giraphConf);
        computation.setConf(conf);
        vertex.setConf(conf);
        vertex.initialize(vertexId, vertexValue);
        if (isHalted) {
            vertex.voteToHalt();
        }
        return env;
    }

    public static CentralizedServiceWorker<IntWritable, IntWritable, IntWritable> mockServiceGetVertexPartitionOwner(final int numOfPartitions) {
        CentralizedServiceWorker service = (CentralizedServiceWorker)Mockito.mock(CentralizedServiceWorker.class);
        Answer<PartitionOwner> answer = new Answer<PartitionOwner>(){

            public PartitionOwner answer(InvocationOnMock invocation) throws Throwable {
                IntWritable vertexId = (IntWritable)invocation.getArguments()[0];
                return new BasicPartitionOwner(vertexId.get() % numOfPartitions, null);
            }
        };
        Mockito.when((Object)service.getVertexPartitionOwner((WritableComparable)Mockito.any(IntWritable.class))).thenAnswer((Answer)answer);
        return service;
    }

    public static ServerData<IntWritable, IntWritable, IntWritable> createNewServerData(ImmutableClassesGiraphConfiguration conf, Mapper.Context context) {
        CentralizedServiceWorker<IntWritable, IntWritable, IntWritable> serviceWorker = MockUtils.mockServiceGetVertexPartitionOwner(1);
        ServerData serverData = new ServerData(serviceWorker, conf, ByteArrayMessagesPerVertexStore.newFactory(serviceWorker, (ImmutableClassesGiraphConfiguration)conf), context);
        serverData.getPartitionStore().addPartition((Partition)new SimplePartition());
        return serverData;
    }

    public static class MockedEnvironment<I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable> {
        private final GraphState graphState = (GraphState)Mockito.mock(GraphState.class);
        private final Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        private final Configuration conf = (Configuration)Mockito.mock(Configuration.class);
        private final WorkerClientRequestProcessor workerClientRequestProcessor = (WorkerClientRequestProcessor)Mockito.mock(WorkerClientRequestProcessor.class);

        public GraphState getGraphState() {
            return this.graphState;
        }

        public Mapper.Context getContext() {
            return this.context;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public WorkerClientRequestProcessor getWorkerClientRequestProcessor() {
            return this.workerClientRequestProcessor;
        }

        public void verifyMessageSent(I targetVertexId, M message) {
            ((WorkerClientRequestProcessor)Mockito.verify((Object)this.workerClientRequestProcessor)).sendMessageRequest(targetVertexId, message);
        }

        public void verifyMessageSentToAllEdges(Vertex<I, V, E> vertex, M message) {
            ((WorkerClientRequestProcessor)Mockito.verify((Object)this.workerClientRequestProcessor)).sendMessageToAllRequest(vertex, message);
        }

        public void verifyNoMessageSent() {
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.workerClientRequestProcessor});
        }
    }
}

