/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.IdWithValueTextOutputFormat;
import org.apache.giraph.io.formats.JsonLongDoubleFloatDoubleVertexInputFormat;
import org.apache.giraph.partition.ByteArrayPartition;
import org.apache.giraph.partition.DiskBackedPartitionStore;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.partition.SimplePartition;
import org.apache.giraph.partition.SimplePartitionStore;
import org.apache.giraph.utils.InternalVertexRunner;
import org.apache.giraph.utils.NoOpComputation;
import org.apache.giraph.utils.UnsafeByteArrayInputStream;
import org.apache.giraph.utils.UnsafeByteArrayOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPartitionStores {
    private ImmutableClassesGiraphConfiguration<IntWritable, IntWritable, NullWritable> conf;
    private Mapper.Context context;
    private static final int NUM_OF_VERTEXES_PER_THREAD = 10;
    private static final int NUM_OF_EDGES_PER_VERTEX = 5;
    private static final int NUM_OF_THREADS = 10;
    private static final int NUM_OF_PARTITIONS = 3;

    private Partition<IntWritable, IntWritable, NullWritable> createPartition(ImmutableClassesGiraphConfiguration<IntWritable, IntWritable, NullWritable> conf, Integer id, Vertex<IntWritable, IntWritable, NullWritable> ... vertices) {
        Partition partition = conf.createPartition(id.intValue(), (Progressable)this.context);
        for (Vertex<IntWritable, IntWritable, NullWritable> v : vertices) {
            partition.putVertex(v);
        }
        return partition;
    }

    @Before
    public void setUp() {
        GiraphConfiguration configuration = new GiraphConfiguration();
        configuration.setComputationClass(MyComputation.class);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)configuration);
        this.context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
    }

    @Test
    public void testSimplePartitionStore() {
        SimplePartitionStore partitionStore = new SimplePartitionStore(this.conf, this.context);
        this.testReadWrite((PartitionStore<IntWritable, IntWritable, NullWritable>)partitionStore, this.conf);
        partitionStore.shutdown();
    }

    @Test
    public void testUnsafePartitionSerializationClass() throws IOException {
        this.conf.setPartitionClass(ByteArrayPartition.class);
        Vertex v1 = this.conf.createVertex();
        v1.initialize((WritableComparable)new IntWritable(1), (Writable)new IntWritable(1));
        Vertex v2 = this.conf.createVertex();
        v2.initialize((WritableComparable)new IntWritable(2), (Writable)new IntWritable(2));
        Vertex v3 = this.conf.createVertex();
        v3.initialize((WritableComparable)new IntWritable(3), (Writable)new IntWritable(3));
        Vertex v4 = this.conf.createVertex();
        v4.initialize((WritableComparable)new IntWritable(4), (Writable)new IntWritable(4));
        Vertex v5 = this.conf.createVertex();
        v5.initialize((WritableComparable)new IntWritable(5), (Writable)new IntWritable(5));
        Vertex v6 = this.conf.createVertex();
        v6.initialize((WritableComparable)new IntWritable(6), (Writable)new IntWritable(6));
        Vertex v7 = this.conf.createVertex();
        v7.initialize((WritableComparable)new IntWritable(7), (Writable)new IntWritable(7));
        Partition<IntWritable, IntWritable, NullWritable> partition = this.createPartition(this.conf, 3, v1, v2, v3, v4, v5, v6, v7);
        Assert.assertEquals((long)3L, (long)partition.getId());
        Assert.assertEquals((long)0L, (long)partition.getEdgeCount());
        Assert.assertEquals((long)7L, (long)partition.getVertexCount());
        UnsafeByteArrayOutputStream outputStream = new UnsafeByteArrayOutputStream();
        partition.write((DataOutput)outputStream);
        UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(outputStream.getByteArray(), 0, outputStream.getPos());
        Partition deserializatedPartition = this.conf.createPartition(-1, (Progressable)this.context);
        deserializatedPartition.readFields((DataInput)inputStream);
        Assert.assertEquals((long)3L, (long)deserializatedPartition.getId());
        Assert.assertEquals((long)0L, (long)deserializatedPartition.getEdgeCount());
        Assert.assertEquals((long)7L, (long)deserializatedPartition.getVertexCount());
    }

    @Test
    public void testDiskBackedPartitionStoreWithByteArrayPartition() throws IOException {
        File directory = Files.createTempDir();
        GiraphConstants.PARTITIONS_DIRECTORY.set(this.conf, new File(directory, "giraph_partitions").toString());
        GiraphConstants.USE_OUT_OF_CORE_GRAPH.set(this.conf, true);
        GiraphConstants.MAX_PARTITIONS_IN_MEMORY.set(this.conf, 1);
        this.conf.setPartitionClass(ByteArrayPartition.class);
        CentralizedServiceWorker serviceWorker = (CentralizedServiceWorker)Mockito.mock(CentralizedServiceWorker.class);
        Mockito.when((Object)serviceWorker.getSuperstep()).thenReturn((Object)-1L);
        DiskBackedPartitionStore partitionStore = new DiskBackedPartitionStore(this.conf, this.context, serviceWorker);
        this.testReadWrite((PartitionStore<IntWritable, IntWritable, NullWritable>)partitionStore, this.conf);
        partitionStore.shutdown();
        FileUtils.deleteDirectory((File)directory);
    }

    @Test
    public void testDiskBackedPartitionStore() throws IOException {
        File directory = Files.createTempDir();
        GiraphConstants.PARTITIONS_DIRECTORY.set(this.conf, new File(directory, "giraph_partitions").toString());
        GiraphConstants.USE_OUT_OF_CORE_GRAPH.set(this.conf, true);
        GiraphConstants.MAX_PARTITIONS_IN_MEMORY.set(this.conf, 1);
        CentralizedServiceWorker serviceWorker = (CentralizedServiceWorker)Mockito.mock(CentralizedServiceWorker.class);
        Mockito.when((Object)serviceWorker.getSuperstep()).thenReturn((Object)-1L);
        DiskBackedPartitionStore partitionStore = new DiskBackedPartitionStore(this.conf, this.context, serviceWorker);
        this.testReadWrite((PartitionStore<IntWritable, IntWritable, NullWritable>)partitionStore, this.conf);
        partitionStore.shutdown();
        GiraphConstants.MAX_PARTITIONS_IN_MEMORY.set(this.conf, 2);
        partitionStore = new DiskBackedPartitionStore(this.conf, this.context, serviceWorker);
        this.testReadWrite((PartitionStore<IntWritable, IntWritable, NullWritable>)partitionStore, this.conf);
        partitionStore.shutdown();
        FileUtils.deleteDirectory((File)directory);
    }

    @Test
    public void testDiskBackedPartitionStoreWithByteArrayComputation() throws Exception {
        String[] graph = new String[]{"[1,0,[]]", "[2,0,[]]", "[3,0,[]]", "[4,0,[]]", "[5,0,[]]", "[6,0,[]]", "[7,0,[]]", "[8,0,[]]", "[9,0,[]]", "[10,0,[]]"};
        String[] expected = new String[]{"1\t0", "2\t0", "3\t0", "4\t0", "5\t0", "6\t0", "7\t0", "8\t0", "9\t0", "10\t0"};
        GiraphConstants.USE_OUT_OF_CORE_GRAPH.set(this.conf, true);
        GiraphConstants.MAX_PARTITIONS_IN_MEMORY.set(this.conf, 1);
        GiraphConstants.USER_PARTITION_COUNT.set(this.conf, 10);
        File directory = Files.createTempDir();
        GiraphConstants.PARTITIONS_DIRECTORY.set(this.conf, new File(directory, "giraph_partitions").toString());
        this.conf.setPartitionClass(ByteArrayPartition.class);
        this.conf.setComputationClass(EmptyComputation.class);
        this.conf.setVertexInputFormatClass(JsonLongDoubleFloatDoubleVertexInputFormat.class);
        this.conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run(this.conf, (String[])graph);
        this.checkResults(results, expected);
        FileUtils.deleteDirectory((File)directory);
    }

    @Test
    public void testDiskBackedPartitionStoreMT() throws Exception {
        GiraphConstants.STATIC_GRAPH.set(this.conf, false);
        this.testMultiThreaded();
    }

    private void testMultiThreaded() throws Exception {
        Partition partition;
        int i;
        AtomicInteger vertexCounter = new AtomicInteger(0);
        ExecutorService pool = Executors.newFixedThreadPool(10);
        ExecutorCompletionService<Boolean> executor = new ExecutorCompletionService<Boolean>(pool);
        File directory = Files.createTempDir();
        GiraphConstants.PARTITIONS_DIRECTORY.set(this.conf, new File(directory, "giraph_partitions").toString());
        GiraphConstants.USE_OUT_OF_CORE_GRAPH.set(this.conf, true);
        GiraphConstants.MAX_PARTITIONS_IN_MEMORY.set(this.conf, 1);
        CentralizedServiceWorker serviceWorker = (CentralizedServiceWorker)Mockito.mock(CentralizedServiceWorker.class);
        Mockito.when((Object)serviceWorker.getSuperstep()).thenReturn((Object)-1L);
        DiskBackedPartitionStore store = new DiskBackedPartitionStore(this.conf, this.context, serviceWorker);
        for (i = 0; i < 10; ++i) {
            int partitionId = i % 3;
            Worker worker = new Worker(vertexCounter, (PartitionStore<IntWritable, IntWritable, NullWritable>)store, partitionId, this.conf);
            executor.submit(worker, new Boolean(true));
        }
        for (i = 0; i < 10; ++i) {
            executor.take();
        }
        pool.shutdownNow();
        int totalVertexes = 0;
        int totalEdges = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            partition = store.getOrCreatePartition(Integer.valueOf(i2));
            totalVertexes = (int)((long)totalVertexes + partition.getVertexCount());
            totalEdges = (int)((long)totalEdges + partition.getEdgeCount());
            store.putPartition(partition);
        }
        assert (vertexCounter.get() == 100);
        assert (totalVertexes == 100);
        assert (totalEdges == totalVertexes * 5);
        int expected = 0;
        for (int i3 = 0; i3 < 100; ++i3) {
            expected += i3;
        }
        int totalValues = 0;
        for (int i4 = 0; i4 < 3; ++i4) {
            partition = store.getOrCreatePartition(Integer.valueOf(i4));
            for (Vertex v : partition) {
                totalValues += ((IntWritable)v.getId()).get();
            }
            store.putPartition(partition);
        }
        assert (totalValues == expected);
        store.shutdown();
    }

    @Test
    public void testDiskBackedPartitionStoreComputation() throws Exception {
        String[] graph = new String[]{"[1,0,[]]", "[2,0,[]]", "[3,0,[]]", "[4,0,[]]", "[5,0,[]]", "[6,0,[]]", "[7,0,[]]", "[8,0,[]]", "[9,0,[]]", "[10,0,[]]"};
        String[] expected = new String[]{"1\t0", "2\t0", "3\t0", "4\t0", "5\t0", "6\t0", "7\t0", "8\t0", "9\t0", "10\t0"};
        GiraphConstants.USE_OUT_OF_CORE_GRAPH.set(this.conf, true);
        GiraphConstants.MAX_PARTITIONS_IN_MEMORY.set(this.conf, 1);
        GiraphConstants.USER_PARTITION_COUNT.set(this.conf, 10);
        File directory = Files.createTempDir();
        GiraphConstants.PARTITIONS_DIRECTORY.set(this.conf, new File(directory, "giraph_partitions").toString());
        this.conf.setComputationClass(EmptyComputation.class);
        this.conf.setVertexInputFormatClass(JsonLongDoubleFloatDoubleVertexInputFormat.class);
        this.conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run(this.conf, (String[])graph);
        this.checkResults(results, expected);
        FileUtils.deleteDirectory((File)directory);
    }

    public void testReadWrite(PartitionStore<IntWritable, IntWritable, NullWritable> partitionStore, ImmutableClassesGiraphConfiguration<IntWritable, IntWritable, NullWritable> conf) {
        Vertex v1 = conf.createVertex();
        v1.initialize((WritableComparable)new IntWritable(1), (Writable)new IntWritable(1));
        Vertex v2 = conf.createVertex();
        v2.initialize((WritableComparable)new IntWritable(2), (Writable)new IntWritable(2));
        Vertex v3 = conf.createVertex();
        v3.initialize((WritableComparable)new IntWritable(3), (Writable)new IntWritable(3));
        Vertex v4 = conf.createVertex();
        v4.initialize((WritableComparable)new IntWritable(4), (Writable)new IntWritable(4));
        Vertex v5 = conf.createVertex();
        v5.initialize((WritableComparable)new IntWritable(5), (Writable)new IntWritable(5));
        Vertex v6 = conf.createVertex();
        v6.initialize((WritableComparable)new IntWritable(7), (Writable)new IntWritable(7));
        Vertex v7 = conf.createVertex();
        v7.initialize((WritableComparable)new IntWritable(7), (Writable)new IntWritable(7));
        v7.addEdge(EdgeFactory.create((WritableComparable)new IntWritable(1)));
        v7.addEdge(EdgeFactory.create((WritableComparable)new IntWritable(2)));
        partitionStore.addPartition(this.createPartition(conf, 1, v1, v2));
        partitionStore.addPartition(this.createPartition(conf, 2, v3));
        partitionStore.addPartition(this.createPartition(conf, 2, v4));
        partitionStore.addPartition(this.createPartition(conf, 3, v5));
        partitionStore.addPartition(this.createPartition(conf, 1, v6));
        partitionStore.addPartition(this.createPartition(conf, 4, v7));
        Partition partition1 = partitionStore.getOrCreatePartition(Integer.valueOf(1));
        partitionStore.putPartition(partition1);
        Partition partition2 = partitionStore.getOrCreatePartition(Integer.valueOf(2));
        partitionStore.putPartition(partition2);
        Partition partition3 = partitionStore.removePartition(Integer.valueOf(3));
        Partition partition4 = partitionStore.getOrCreatePartition(Integer.valueOf(4));
        partitionStore.putPartition(partition4);
        Assert.assertEquals((long)3L, (long)partitionStore.getNumPartitions());
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)partitionStore.getPartitionIds()));
        int partitionsNumber = 0;
        for (Integer partitionId : partitionStore.getPartitionIds()) {
            Partition p = partitionStore.getOrCreatePartition(partitionId);
            partitionStore.putPartition(p);
            ++partitionsNumber;
        }
        Assert.assertEquals((long)3L, (long)partitionsNumber);
        Assert.assertTrue((boolean)partitionStore.hasPartition(Integer.valueOf(1)));
        Assert.assertTrue((boolean)partitionStore.hasPartition(Integer.valueOf(2)));
        Assert.assertFalse((boolean)partitionStore.hasPartition(Integer.valueOf(3)));
        Assert.assertTrue((boolean)partitionStore.hasPartition(Integer.valueOf(4)));
        Partition partition = partitionStore.getOrCreatePartition(Integer.valueOf(1));
        Assert.assertEquals((long)3L, (long)partition.getVertexCount());
        partitionStore.putPartition(partition);
        partition = partitionStore.getOrCreatePartition(Integer.valueOf(2));
        Assert.assertEquals((long)2L, (long)partition.getVertexCount());
        partitionStore.putPartition(partition);
        partition = partitionStore.getOrCreatePartition(Integer.valueOf(4));
        Assert.assertEquals((long)1L, (long)partition.getVertexCount());
        Assert.assertEquals((long)2L, (long)partition.getEdgeCount());
        partitionStore.putPartition(partition);
        partitionStore.deletePartition(Integer.valueOf(2));
        Assert.assertEquals((long)2L, (long)partitionStore.getNumPartitions());
    }

    private void checkResults(Iterable<String> results, String[] expected) {
        Iterator<String> result = results.iterator();
        assert (results != null);
        while (result.hasNext()) {
            String resultStr = result.next();
            boolean found = false;
            for (int j = 0; j < expected.length; ++j) {
                if (!expected[j].equals(resultStr)) continue;
                found = true;
            }
            assert (found);
        }
    }

    @Test
    public void testEdgeCombineWithSimplePartition() throws IOException {
        this.testEdgeCombine(SimplePartition.class);
    }

    @Test
    public void testEdgeCombineWithByteArrayPartition() throws IOException {
        this.testEdgeCombine(ByteArrayPartition.class);
    }

    private void testEdgeCombine(Class<? extends Partition> partitionClass) throws IOException {
        Vertex v1 = this.conf.createVertex();
        v1.initialize((WritableComparable)new IntWritable(1), (Writable)new IntWritable(1));
        Vertex v2 = this.conf.createVertex();
        v2.initialize((WritableComparable)new IntWritable(2), (Writable)new IntWritable(2));
        Vertex v3 = this.conf.createVertex();
        v3.initialize((WritableComparable)new IntWritable(3), (Writable)new IntWritable(3));
        Vertex v1e2 = this.conf.createVertex();
        v1e2.initialize((WritableComparable)new IntWritable(1), (Writable)new IntWritable(1));
        v1e2.addEdge(EdgeFactory.create((WritableComparable)new IntWritable(2)));
        Vertex v1e3 = this.conf.createVertex();
        v1e3.initialize((WritableComparable)new IntWritable(1), (Writable)new IntWritable(1));
        v1e3.addEdge(EdgeFactory.create((WritableComparable)new IntWritable(3)));
        GiraphConfiguration newconf = new GiraphConfiguration(this.conf);
        newconf.setPartitionClass(partitionClass);
        Partition partition = new ImmutableClassesGiraphConfiguration((Configuration)newconf).createPartition(1, (Progressable)this.context);
        Assert.assertEquals(partitionClass, partition.getClass());
        partition.putVertex(v1);
        partition.putVertex(v2);
        partition.putVertex(v3);
        Assert.assertEquals((long)3L, (long)partition.getVertexCount());
        Assert.assertEquals((long)0L, (long)partition.getEdgeCount());
        partition.putOrCombine(v1e2);
        Assert.assertEquals((long)3L, (long)partition.getVertexCount());
        Assert.assertEquals((long)1L, (long)partition.getEdgeCount());
        partition.putOrCombine(v1e3);
        Assert.assertEquals((long)3L, (long)partition.getVertexCount());
        Assert.assertEquals((long)2L, (long)partition.getEdgeCount());
        v1 = partition.getVertex((WritableComparable)new IntWritable(1));
        Assert.assertEquals((Object)new IntWritable(1), (Object)v1.getId());
        Assert.assertEquals((Object)new IntWritable(1), (Object)v1.getValue());
        Assert.assertEquals((long)2L, (long)v1.getNumEdges());
    }

    private class Worker
    implements Runnable {
        private final AtomicInteger vertexCounter;
        private final PartitionStore<IntWritable, IntWritable, NullWritable> partitionStore;
        private final int partitionId;
        private final ImmutableClassesGiraphConfiguration<IntWritable, IntWritable, NullWritable> conf;

        public Worker(AtomicInteger vertexCounter, PartitionStore<IntWritable, IntWritable, NullWritable> partitionStore, int partitionId, ImmutableClassesGiraphConfiguration<IntWritable, IntWritable, NullWritable> conf) {
            this.vertexCounter = vertexCounter;
            this.partitionStore = partitionStore;
            this.partitionId = partitionId;
            this.conf = conf;
        }

        @Override
        public void run() {
            for (int i = 0; i < 10; ++i) {
                int id = this.vertexCounter.getAndIncrement();
                Vertex v = this.conf.createVertex();
                v.initialize((WritableComparable)new IntWritable(id), (Writable)new IntWritable(id));
                Partition partition = this.partitionStore.getOrCreatePartition(Integer.valueOf(this.partitionId));
                Random rand = new Random(id);
                for (int j = 0; j < 5; ++j) {
                    int dest = rand.nextInt(id + 1);
                    v.addEdge(EdgeFactory.create((WritableComparable)new IntWritable(dest)));
                }
                partition.putVertex(v);
                this.partitionStore.putPartition(partition);
            }
        }
    }

    public static class EmptyComputation
    extends BasicComputation<LongWritable, DoubleWritable, FloatWritable, LongWritable> {
        public void compute(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex, Iterable<LongWritable> messages) throws IOException {
            vertex.voteToHalt();
        }
    }

    public static class MyComputation
    extends NoOpComputation<IntWritable, IntWritable, NullWritable, IntWritable> {
    }
}

