/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import java.io.IOException;
import org.apache.giraph.edge.ArrayListEdges;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.DefaultVertex;
import org.apache.giraph.graph.GiraphTransferRegulator;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.job.GiraphJob;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.NoOpComputation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestGiraphTransferRegulator {
    private GiraphJob job;
    private Vertex<IntWritable, FloatWritable, DoubleWritable> vertex = new DefaultVertex();

    @Before
    public void setUp() {
        try {
            this.job = new GiraphJob("TestGiraphTransferRegulator");
        }
        catch (IOException e) {
            throw new RuntimeException("setUp: Failed", e);
        }
        this.job.getConfiguration().setComputationClass(TestComputation.class);
    }

    @Test
    public void testGiraphTransferRegulator() {
        this.job.getConfiguration().setInt("giraph.maxVerticesPerTransfer", 1);
        this.job.getConfiguration().setInt("giraph.maxEdgesPerTransfer", 3);
        ArrayListEdges edges = new ArrayListEdges();
        edges.initialize(3);
        edges.add(EdgeFactory.create((WritableComparable)new IntWritable(2), (Writable)new DoubleWritable(22.0)));
        edges.add(EdgeFactory.create((WritableComparable)new IntWritable(3), (Writable)new DoubleWritable(33.0)));
        edges.add(EdgeFactory.create((WritableComparable)new IntWritable(4), (Writable)new DoubleWritable(44.0)));
        this.vertex.initialize((WritableComparable)new IntWritable(1), (Writable)new FloatWritable(1.0f), (Iterable)edges);
        GiraphTransferRegulator gtr = new GiraphTransferRegulator((Configuration)this.job.getConfiguration());
        PartitionOwner owner = (PartitionOwner)Mockito.mock(PartitionOwner.class);
        Mockito.when((Object)owner.getPartitionId()).thenReturn((Object)57);
        Assert.assertFalse((boolean)gtr.transferThisPartition(owner));
        gtr.incrementCounters(owner, this.vertex);
        Assert.assertTrue((boolean)gtr.transferThisPartition(owner));
    }

    public static class TestComputation
    extends NoOpComputation<IntWritable, FloatWritable, DoubleWritable, LongWritable> {
    }
}

