/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.SimpleLongRangePartitionerFactory;
import org.apache.giraph.partition.WorkerGraphPartitioner;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Test;

public class SimpleRangePartitionFactoryTest {
    private void testRange(int numWorkers, int keySpaceSize, int allowedWorkerDiff, boolean emptyWorkers) {
        Configuration conf = new Configuration();
        conf.setLong("giraph.vertexKeySpaceSize", (long)keySpaceSize);
        SimpleLongRangePartitionerFactory factory = new SimpleLongRangePartitionerFactory();
        factory.setConf(new ImmutableClassesGiraphConfiguration(conf));
        ArrayList<WorkerInfo> infos = new ArrayList<WorkerInfo>();
        for (int i = 0; i < numWorkers; ++i) {
            WorkerInfo info = new WorkerInfo();
            info.setInetSocketAddress(new InetSocketAddress(8080));
            info.setTaskId(i);
            infos.add(info);
        }
        Collection owners = factory.createMasterGraphPartitioner().createInitialPartitionOwners(infos, -1);
        int[] tasks = new int[owners.size()];
        for (PartitionOwner owner : owners) {
            WorkerInfo worker = owner.getWorkerInfo();
            Assert.assertEquals((long)0L, (long)tasks[owner.getPartitionId()]);
            tasks[owner.getPartitionId()] = worker.getTaskId() + 1;
        }
        this.checkMapping(tasks, allowedWorkerDiff, emptyWorkers);
        WorkerGraphPartitioner workerPartitioner = factory.createWorkerGraphPartitioner();
        workerPartitioner.updatePartitionOwners(null, owners);
        LongWritable longWritable = new LongWritable();
        int[] partitions = new int[keySpaceSize];
        for (int i = 0; i < keySpaceSize; ++i) {
            longWritable.set((long)i);
            PartitionOwner owner = workerPartitioner.getPartitionOwner((WritableComparable)longWritable);
            partitions[i] = owner.getPartitionId();
        }
        this.checkMapping(partitions, 1, emptyWorkers);
    }

    private void checkMapping(int[] mapping, int allowedDiff, boolean emptyWorkers) {
        int prev = -1;
        int max = 0;
        int min = Integer.MAX_VALUE;
        int cur = 0;
        for (int value : mapping) {
            if (value != prev) {
                if (prev != -1) {
                    min = Math.min(cur, min);
                    max = Math.max(cur, max);
                    Assert.assertTrue((prev < value ? 1 : 0) != 0);
                    if (!emptyWorkers) {
                        Assert.assertEquals((long)(prev + 1), (long)value);
                    }
                }
                cur = 1;
            } else {
                ++cur;
            }
            prev = value;
        }
        Assert.assertTrue((min + allowedDiff >= max ? 1 : 0) != 0);
    }

    @Test
    public void testLongRangePartitionerFactory() {
        this.testRange(10, 100000, 0, false);
        this.testRange(1000, 100000, 0, false);
        this.testRange(8949, 100023, 0, false);
        this.testRange(1949, 211111, 0, false);
        this.testRange(194942, 211111, 1, true);
    }
}

