/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.giraph.master.DefaultMasterObserver;
import org.apache.giraph.utils.InternalVertexRunner;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMasterObserver {
    @Test
    public void testGetsCalled() throws Exception {
        Assert.assertEquals((long)0L, (long)Obs.postApp);
        String[] graph = new String[]{"1", "2", "3"};
        String[] klasses = new String[]{Obs.class.getName(), Obs.class.getName()};
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.set(GiraphConstants.MASTER_OBSERVER_CLASSES.getKey(), StringUtils.arrayToString((String[])klasses));
        conf.setComputationClass(SimpleComputation.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setVertexInputFormatClass(InputFormat.class);
        InternalVertexRunner.run((GiraphConfiguration)conf, (String[])graph);
        Assert.assertEquals((long)2L, (long)Obs.preApp);
        Assert.assertEquals((long)8L, (long)Obs.preSuperstep);
        Assert.assertEquals((long)8L, (long)Obs.postSuperstep);
        Assert.assertEquals((long)2L, (long)Obs.postApp);
    }

    public static class Obs
    extends DefaultMasterObserver {
        public static int preApp = 0;
        public static int preSuperstep = 0;
        public static int postSuperstep = 0;
        public static int postApp = 0;

        public void preApplication() {
            ++preApp;
        }

        public void postApplication() {
            ++postApp;
        }

        public void preSuperstep(long superstep) {
            ++preSuperstep;
        }

        public void postSuperstep(long superstep) {
            ++postSuperstep;
        }
    }

    public static class InputFormat
    extends TextVertexInputFormat<IntWritable, IntWritable, NullWritable> {
        public TextVertexInputFormat.TextVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
            return new TextVertexInputFormat.TextVertexReaderFromEachLine(){

                protected IntWritable getId(Text line) throws IOException {
                    return new IntWritable(Integer.parseInt(line.toString()));
                }

                protected IntWritable getValue(Text line) throws IOException {
                    return new IntWritable(0);
                }

                protected Iterable<Edge<IntWritable, NullWritable>> getEdges(Text line) throws IOException {
                    return ImmutableList.of();
                }
            };
        }
    }

    public static class SimpleComputation
    extends BasicComputation<IntWritable, IntWritable, NullWritable, NullWritable> {
        public void compute(Vertex<IntWritable, IntWritable, NullWritable> vertex, Iterable<NullWritable> messages) throws IOException {
            int currentValue = ((IntWritable)vertex.getValue()).get();
            if (currentValue == 2) {
                vertex.voteToHalt();
            }
            vertex.setValue((Writable)new IntWritable(currentValue + 1));
        }
    }
}

