/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import java.io.IOException;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.AbstractComputation;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.master.SuperstepClasses;
import org.apache.giraph.utils.IntNoOpComputation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Test;

public class TestComputationCombinerTypes {
    @Test
    public void testAllMatchWithoutCombiner() {
        SuperstepClasses classes = new SuperstepClasses(IntNoOpComputation.class, null);
        classes.verifyTypesMatch(TestComputationCombinerTypes.createConfiguration(IntNoOpComputation.class), true);
    }

    @Test
    public void testAllMatchWithCombiner() {
        SuperstepClasses classes = new SuperstepClasses(IntIntIntLongDoubleComputation.class, IntDoubleMessageCombiner.class);
        classes.verifyTypesMatch(TestComputationCombinerTypes.createConfiguration(IntIntIntIntLongComputation.class), true);
    }

    @Test(expected=IllegalStateException.class)
    public void testDifferentIdTypes() {
        SuperstepClasses classes = new SuperstepClasses(LongIntIntLongIntComputation.class, null);
        classes.verifyTypesMatch(TestComputationCombinerTypes.createConfiguration(IntIntIntIntLongComputation.class), true);
    }

    @Test(expected=IllegalStateException.class)
    public void testDifferentVertexValueTypes() {
        SuperstepClasses classes = new SuperstepClasses(IntLongIntLongIntComputation.class, null);
        classes.verifyTypesMatch(TestComputationCombinerTypes.createConfiguration(IntIntIntIntLongComputation.class), true);
    }

    @Test(expected=IllegalStateException.class)
    public void testDifferentEdgeDataTypes() {
        SuperstepClasses classes = new SuperstepClasses(IntIntLongLongIntComputation.class, null);
        classes.verifyTypesMatch(TestComputationCombinerTypes.createConfiguration(IntIntIntIntLongComputation.class), true);
    }

    @Test(expected=IllegalStateException.class)
    public void testDifferentMessageTypes() {
        SuperstepClasses classes = new SuperstepClasses(IntIntIntIntLongComputation.class, null);
        classes.verifyTypesMatch(TestComputationCombinerTypes.createConfiguration(IntIntIntLongDoubleComputation.class), true);
    }

    @Test(expected=IllegalStateException.class)
    public void testDifferentCombinerIdType() {
        SuperstepClasses classes = new SuperstepClasses(IntIntIntLongDoubleComputation.class, DoubleDoubleMessageCombiner.class);
        classes.verifyTypesMatch(TestComputationCombinerTypes.createConfiguration(IntIntIntIntLongComputation.class), true);
    }

    @Test(expected=IllegalStateException.class)
    public void testDifferentCombinerMessageType() {
        SuperstepClasses classes = new SuperstepClasses(IntIntIntLongDoubleComputation.class, IntLongMessageCombiner.class);
        classes.verifyTypesMatch(TestComputationCombinerTypes.createConfiguration(IntIntIntIntLongComputation.class), true);
    }

    private static ImmutableClassesGiraphConfiguration createConfiguration(Class<? extends Computation> computationClass) {
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(computationClass);
        return new ImmutableClassesGiraphConfiguration((Configuration)conf);
    }

    private static class IntLongMessageCombiner
    extends NoOpMessageCombiner<IntWritable, LongWritable> {
        private IntLongMessageCombiner() {
        }
    }

    private static class DoubleDoubleMessageCombiner
    extends NoOpMessageCombiner<DoubleWritable, DoubleWritable> {
        private DoubleDoubleMessageCombiner() {
        }
    }

    private static class IntDoubleMessageCombiner
    extends NoOpMessageCombiner<IntWritable, DoubleWritable> {
        private IntDoubleMessageCombiner() {
        }
    }

    private static class NoOpMessageCombiner<I extends WritableComparable, M extends Writable>
    extends MessageCombiner<I, M> {
        private NoOpMessageCombiner() {
        }

        public void combine(I vertexIndex, M originalMessage, M messageToCombine) {
        }

        public M createInitialMessage() {
            return null;
        }
    }

    private static class IntIntLongLongIntComputation
    extends NoOpComputation<IntWritable, IntWritable, LongWritable, LongWritable, IntWritable> {
        private IntIntLongLongIntComputation() {
        }
    }

    private static class IntLongIntLongIntComputation
    extends NoOpComputation<IntWritable, LongWritable, IntWritable, LongWritable, IntWritable> {
        private IntLongIntLongIntComputation() {
        }
    }

    private static class LongIntIntLongIntComputation
    extends NoOpComputation<LongWritable, IntWritable, IntWritable, LongWritable, IntWritable> {
        private LongIntIntLongIntComputation() {
        }
    }

    private static class IntIntIntLongDoubleComputation
    extends NoOpComputation<IntWritable, IntWritable, IntWritable, LongWritable, DoubleWritable> {
        private IntIntIntLongDoubleComputation() {
        }
    }

    private static class IntIntIntIntLongComputation
    extends NoOpComputation<IntWritable, IntWritable, IntWritable, IntWritable, LongWritable> {
        private IntIntIntIntLongComputation() {
        }
    }

    public static class NoOpComputation<I extends WritableComparable, V extends Writable, E extends Writable, M1 extends Writable, M2 extends Writable>
    extends AbstractComputation<I, V, E, M1, M2> {
        public void compute(Vertex<I, V, E> vertex, Iterable<M1> messages) throws IOException {
        }
    }
}

