/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.giraph.jython.wrappers.JythonWritableWrapper;
import org.junit.Assert;
import org.junit.Test;
import org.python.core.PyClass;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class TestJythonWritableWrapper {
    @Test
    public void testWrap() throws IOException {
        String jython = "class Foo:\n    def __init__(self):\n        self.val = 17\n\n    def do_add(self, x):\n        self.val += x\n\n    def do_add_squared(self, x):\n        self.do_add(x * x)\n\n    def new_other(self):\n        self.other_val = 3\n\ndef outside_add_squared(foo, x):\n    foo.do_add_squared(x)\n\n";
        PythonInterpreter interpreter = new PythonInterpreter();
        interpreter.exec(jython);
        PyObject fooClass = interpreter.get("Foo");
        Assert.assertTrue((boolean)(fooClass instanceof PyClass));
        PyObject foo = fooClass.__call__();
        PyObject fooVal = foo.__getattr__("val");
        Assert.assertTrue((boolean)(fooVal instanceof PyInteger));
        PyInteger val = (PyInteger)fooVal;
        Assert.assertEquals((long)17L, (long)val.getValue());
        PyObject function = interpreter.get("outside_add_squared");
        Assert.assertTrue((String)("method class: " + function.getClass()), (boolean)(function instanceof PyFunction));
        function.__call__(foo, (PyObject)new PyInteger(3));
        fooVal = foo.__getattr__("val");
        Assert.assertTrue((boolean)(fooVal instanceof PyInteger));
        val = (PyInteger)fooVal;
        Assert.assertEquals((long)26L, (long)val.getValue());
        JythonWritableWrapper wrappedFoo = new JythonWritableWrapper(foo);
        PyObject newOtherMethod = wrappedFoo.__getattr__("new_other");
        Assert.assertTrue((boolean)(newOtherMethod instanceof PyMethod));
        newOtherMethod.__call__();
        function.__call__((PyObject)wrappedFoo, (PyObject)new PyInteger(2));
        fooVal = foo.__getattr__("val");
        Assert.assertTrue((boolean)(fooVal instanceof PyInteger));
        val = (PyInteger)fooVal;
        Assert.assertEquals((long)30L, (long)val.getValue());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        wrappedFoo.write((DataOutput)dos);
        byte[] data = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        PyObject foo2 = fooClass.__call__();
        PyObject foo2Val = foo2.__getattr__("val");
        Assert.assertTrue((boolean)(foo2Val instanceof PyInteger));
        PyInteger val2 = (PyInteger)foo2Val;
        Assert.assertEquals((long)17L, (long)val2.getValue());
        JythonWritableWrapper wrappedFoo2 = new JythonWritableWrapper(foo2);
        foo2Val = wrappedFoo2.getPyObject().__getattr__("val");
        Assert.assertTrue((boolean)(foo2Val instanceof PyInteger));
        val2 = (PyInteger)foo2Val;
        Assert.assertEquals((long)17L, (long)val2.getValue());
        wrappedFoo2.readFields((DataInput)dis);
        foo2Val = wrappedFoo2.getPyObject().__getattr__("val");
        Assert.assertTrue((boolean)(foo2Val instanceof PyInteger));
        val2 = (PyInteger)foo2Val;
        Assert.assertEquals((long)30L, (long)val2.getValue());
    }
}

