/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.giraph.comm.messages.InMemoryMessageStoreFactory;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.out_of_core.DiskBackedMessageStoreFactory;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.GiraphTypes;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.graph.Language;
import org.apache.giraph.io.formats.IdWithValueTextOutputFormat;
import org.apache.giraph.io.formats.IntNullTextEdgeInputFormat;
import org.apache.giraph.jython.JythonUtils;
import org.apache.giraph.scripting.DeployType;
import org.apache.giraph.scripting.ScriptLoader;
import org.apache.giraph.utils.InternalVertexRunner;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestJythonComputation {
    @Test
    public void testCountEdgesDiskBackedMessageStoreFactory() throws Exception {
        this.testCountEdges(DiskBackedMessageStoreFactory.class);
    }

    @Test
    public void testCountEdgesInMemoryMessageStoreFactory() throws Exception {
        this.testCountEdges(InMemoryMessageStoreFactory.class);
    }

    public void testCountEdges(Class<? extends MessageStoreFactory> messageStoreFactoryClass) throws Exception {
        String[] edges = new String[]{"1 2", "2 3", "2 4", "4 1"};
        GiraphConfiguration conf = new GiraphConfiguration();
        GiraphTypes types = new GiraphTypes(IntWritable.class, IntWritable.class, NullWritable.class, NullWritable.class, NullWritable.class);
        types.writeIfUnset((Configuration)conf);
        ScriptLoader.setScriptsToLoad((Configuration)conf, (String)"org/apache/giraph/jython/count-edges.py", (DeployType)DeployType.RESOURCE, (Language)Language.JYTHON);
        JythonUtils.init((Configuration)conf, (String)"CountEdges");
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setEdgeInputFormatClass(IntNullTextEdgeInputFormat.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        GiraphConstants.MESSAGE_STORE_FACTORY_CLASS.set((Configuration)conf, messageStoreFactoryClass);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, null, (String[])edges);
        Map<Integer, Integer> values = TestJythonComputation.parseResults(results);
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertEquals((long)1L, (long)values.get(1).intValue());
        Assert.assertEquals((long)2L, (long)values.get(2).intValue());
        Assert.assertEquals((long)1L, (long)values.get(4).intValue());
    }

    private static Map<Integer, Integer> parseResults(Iterable<String> results) {
        HashMap values = Maps.newHashMap();
        for (String line : results) {
            String[] tokens = line.split("\\s+");
            int id = Integer.valueOf(tokens[0]);
            int value = Integer.valueOf(tokens[1]);
            values.put(id, value);
        }
        return values;
    }
}

