/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython;

import org.junit.Assert;
import org.junit.Test;
import org.python.core.PyClass;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class TestJythonBasic {
    private static final double DELTA = 1.0E-7;

    @Test
    public void testBasic() {
        String jython = "class Foo:\n    def __init__(self):\n        self.map = {\"32\": 32, \"4.3\": 4.3}\n        self.list = [ 2, 9, 11 ]\n        self.ival = 17\n\ndef get_map(foo):\n    return foo.map\n\ndef get_list(foo):\n    return foo.list\n\ndef get_ival(foo):\n    return foo.ival\n";
        PythonInterpreter interpreter = new PythonInterpreter();
        interpreter.exec(jython);
        PyObject fooClass = interpreter.get("Foo");
        Assert.assertTrue((boolean)(fooClass instanceof PyClass));
        PyObject getMapFunc = interpreter.get("get_map");
        PyObject getListFunc = interpreter.get("get_list");
        PyObject getIValFunc = interpreter.get("get_ival");
        PyObject foo = fooClass.__call__();
        PyObject mapResult = getMapFunc.__call__(foo);
        Assert.assertTrue((boolean)(mapResult instanceof PyDictionary));
        PyDictionary pyMapResult = (PyDictionary)mapResult;
        Assert.assertEquals((long)2L, (long)pyMapResult.size());
        Object thirtyTwo = pyMapResult.get((Object)"32");
        Assert.assertTrue((boolean)(thirtyTwo instanceof Integer));
        Assert.assertEquals((long)32L, (long)((Integer)thirtyTwo).intValue());
        Object fourPointThree = pyMapResult.get((Object)"4.3");
        Assert.assertTrue((boolean)(fourPointThree instanceof Double));
        Assert.assertEquals((double)4.3, (double)((Double)fourPointThree), (double)1.0E-7);
        PyObject listResult = getListFunc.__call__(foo);
        Assert.assertTrue((boolean)(listResult instanceof PyList));
        PyList pyListResult = (PyList)listResult;
        Assert.assertEquals((long)3L, (long)pyListResult.size());
        Assert.assertEquals((Object)2, (Object)pyListResult.get(0));
        Assert.assertEquals((Object)9, (Object)pyListResult.get(1));
        Assert.assertEquals((Object)11, (Object)pyListResult.get(2));
        PyObject ivalResult = getIValFunc.__call__(foo);
        Assert.assertTrue((boolean)(ivalResult instanceof PyInteger));
        Assert.assertEquals((long)17L, (long)((PyInteger)ivalResult).getValue());
    }
}

