/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.giraph.BspCase;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.factories.VertexValueFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexValueCombiner;
import org.apache.giraph.io.formats.IdWithValueTextOutputFormat;
import org.apache.giraph.io.formats.IntIntNullTextVertexInputFormat;
import org.apache.giraph.io.formats.IntIntTextVertexValueInputFormat;
import org.apache.giraph.io.formats.IntNullReverseTextEdgeInputFormat;
import org.apache.giraph.io.formats.IntNullTextEdgeInputFormat;
import org.apache.giraph.utils.ComputationCountEdges;
import org.apache.giraph.utils.IntIntNullNoOpComputation;
import org.apache.giraph.utils.InternalVertexRunner;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestVertexEdgeInput
extends BspCase {
    public TestVertexEdgeInput() {
        super(TestVertexEdgeInput.class.getName());
    }

    @Test
    public void testEdgesOnly() throws Exception {
        String[] edges = new String[]{"1 2", "2 3", "2 4", "4 1"};
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(ComputationCountEdges.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setEdgeInputFormatClass(IntNullTextEdgeInputFormat.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, null, (String[])edges);
        Map<Integer, Integer> values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertEquals((long)1L, (long)values.get(1).intValue());
        Assert.assertEquals((long)2L, (long)values.get(2).intValue());
        Assert.assertEquals((long)1L, (long)values.get(4).intValue());
    }

    @Test
    public void testEdgesOnlyWithReverse() throws Exception {
        String[] edges = new String[]{"1 2", "2 3", "2 4", "4 1"};
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(ComputationCountEdges.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setEdgeInputFormatClass(IntNullReverseTextEdgeInputFormat.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, null, (String[])edges);
        Map<Integer, Integer> values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)4L, (long)values.size());
        Assert.assertEquals((long)2L, (long)values.get(1).intValue());
        Assert.assertEquals((long)3L, (long)values.get(2).intValue());
        Assert.assertEquals((long)1L, (long)values.get(3).intValue());
        Assert.assertEquals((long)2L, (long)values.get(4).intValue());
    }

    @Test
    public void testVertexValueCombiner() throws Exception {
        String[] vertices = new String[]{"1 75 2", "2 34 3", "3 13", "4 32", "1 11", "2 23 1", "2 3"};
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(IntIntNullNoOpComputation.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setVertexInputFormatClass(IntIntNullTextVertexInputFormat.class);
        conf.setVertexValueCombinerClass(IntSumVertexValueCombiner.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices);
        Map<Integer, Integer> values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)4L, (long)values.size());
        Assert.assertEquals((long)86L, (long)values.get(1).intValue());
        Assert.assertEquals((long)60L, (long)values.get(2).intValue());
        Assert.assertEquals((long)13L, (long)values.get(3).intValue());
        Assert.assertEquals((long)32L, (long)values.get(4).intValue());
        conf.setComputationClass(ComputationCountEdges.class);
        results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices);
        values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)1L, (long)values.get(1).intValue());
        Assert.assertEquals((long)2L, (long)values.get(2).intValue());
        Assert.assertEquals((long)0L, (long)values.get(3).intValue());
        Assert.assertEquals((long)0L, (long)values.get(4).intValue());
    }

    @Test
    public void testMixedVertexValueEdgeFormat() throws Exception {
        String[] vertices = new String[]{"1 75", "2 34", "3 13", "4 32"};
        String[] edges = new String[]{"1 2", "2 3", "2 4", "4 1", "5 3"};
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(IntIntNullNoOpComputation.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setVertexInputFormatClass(IntIntTextVertexValueInputFormat.class);
        conf.setEdgeInputFormatClass(IntNullTextEdgeInputFormat.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        Map<Integer, Integer> values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)5L, (long)values.size());
        Assert.assertEquals((long)75L, (long)values.get(1).intValue());
        Assert.assertEquals((long)34L, (long)values.get(2).intValue());
        Assert.assertEquals((long)13L, (long)values.get(3).intValue());
        Assert.assertEquals((long)32L, (long)values.get(4).intValue());
        Assert.assertEquals((long)0L, (long)values.get(5).intValue());
        conf.setVertexValueFactoryClass(TestVertexValueFactory.class);
        results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)3L, (long)values.get(5).intValue());
        conf = new GiraphConfiguration();
        conf.setComputationClass(ComputationCountEdges.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setVertexInputFormatClass(IntIntTextVertexValueInputFormat.class);
        conf.setEdgeInputFormatClass(IntNullTextEdgeInputFormat.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)1L, (long)values.get(1).intValue());
        Assert.assertEquals((long)2L, (long)values.get(2).intValue());
        Assert.assertEquals((long)0L, (long)values.get(3).intValue());
        Assert.assertEquals((long)1L, (long)values.get(4).intValue());
        Assert.assertEquals((long)1L, (long)values.get(5).intValue());
    }

    @Test
    public void testMixedVertexEdgeFormat() throws Exception {
        String[] vertices = new String[]{"1 75 2 3", "2 34 1 5", "3 13", "4 32"};
        String[] edges = new String[]{"1 2", "2 3", "2 4", "4 1", "5 3"};
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(IntIntNullNoOpComputation.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setVertexInputFormatClass(IntIntNullTextVertexInputFormat.class);
        conf.setEdgeInputFormatClass(IntNullTextEdgeInputFormat.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        Map<Integer, Integer> values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)5L, (long)values.size());
        Assert.assertEquals((long)75L, (long)values.get(1).intValue());
        Assert.assertEquals((long)34L, (long)values.get(2).intValue());
        Assert.assertEquals((long)13L, (long)values.get(3).intValue());
        Assert.assertEquals((long)32L, (long)values.get(4).intValue());
        Assert.assertEquals((long)0L, (long)values.get(5).intValue());
        conf.setVertexValueFactoryClass(TestVertexValueFactory.class);
        results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)3L, (long)values.get(5).intValue());
        conf = new GiraphConfiguration();
        conf.setComputationClass(ComputationCountEdges.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setVertexInputFormatClass(IntIntNullTextVertexInputFormat.class);
        conf.setEdgeInputFormatClass(IntNullTextEdgeInputFormat.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)3L, (long)values.get(1).intValue());
        Assert.assertEquals((long)4L, (long)values.get(2).intValue());
        Assert.assertEquals((long)0L, (long)values.get(3).intValue());
        Assert.assertEquals((long)1L, (long)values.get(4).intValue());
        Assert.assertEquals((long)1L, (long)values.get(5).intValue());
    }

    @Test
    public void testDifferentInputEdgesClass() throws Exception {
        String[] edges = new String[]{"1 2", "2 3", "2 4", "4 1"};
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(TestComputationCheckEdgesType.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setInputOutEdgesClass(TestOutEdgesFilterEven.class);
        conf.setEdgeInputFormatClass(IntNullTextEdgeInputFormat.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, null, (String[])edges);
        Map<Integer, Integer> values = TestVertexEdgeInput.parseResults(results);
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertEquals((long)1L, (long)values.get(1).intValue());
        Assert.assertEquals((long)1L, (long)values.get(2).intValue());
        Assert.assertEquals((long)0L, (long)values.get(4).intValue());
    }

    private static Map<Integer, Integer> parseResults(Iterable<String> results) {
        HashMap values = Maps.newHashMap();
        for (String line : results) {
            String[] tokens = line.split("\\s+");
            int id = Integer.valueOf(tokens[0]);
            int value = Integer.valueOf(tokens[1]);
            values.put(id, value);
        }
        return values;
    }

    public static class TestOutEdgesFilterEven
    extends ByteArrayEdges<IntWritable, NullWritable> {
        public void add(Edge<IntWritable, NullWritable> edge) {
            if (((IntWritable)edge.getTargetVertexId()).get() % 2 == 0) {
                super.add(edge);
            }
        }
    }

    public static class TestVertexValueFactory
    implements VertexValueFactory<IntWritable> {
        public void initialize(ImmutableClassesGiraphConfiguration conf) {
        }

        public Class<IntWritable> getValueClass() {
            return IntWritable.class;
        }

        public IntWritable newInstance() {
            return new IntWritable(3);
        }
    }

    public static class TestComputationCheckEdgesType
    extends ComputationCountEdges {
        @Override
        public void compute(Vertex<IntWritable, IntWritable, NullWritable> vertex, Iterable<NullWritable> messages) throws IOException {
            Assert.assertFalse((boolean)(vertex.getEdges() instanceof TestOutEdgesFilterEven));
            Assert.assertTrue((boolean)(vertex.getEdges() instanceof ByteArrayEdges));
            super.compute(vertex, messages);
        }
    }

    public static class IntSumVertexValueCombiner
    implements VertexValueCombiner<IntWritable> {
        public void combine(IntWritable originalVertexValue, IntWritable vertexValue) {
            originalVertexValue.set(originalVertexValue.get() + vertexValue.get());
        }
    }
}

