/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import java.io.IOException;
import java.util.Arrays;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.AdjacencyListTextVertexInputFormat;
import org.apache.giraph.io.formats.TextDoubleDoubleAdjacencyListVertexInputFormat;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.giraph.utils.NoOpComputation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTextDoubleDoubleAdjacencyListVertexInputFormat
extends TextDoubleDoubleAdjacencyListVertexInputFormat {
    private RecordReader<LongWritable, Text> rr;
    private ImmutableClassesGiraphConfiguration<Text, DoubleWritable, DoubleWritable> conf;
    private TaskAttemptContext tac;

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.rr = (RecordReader)Mockito.mock(RecordReader.class);
        Mockito.when((Object)this.rr.nextKeyValue()).thenReturn((Object)true).thenReturn((Object)false);
        GiraphConfiguration giraphConf = new GiraphConfiguration();
        giraphConf.setComputationClass(DummyComputation.class);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)giraphConf);
        this.tac = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)this.tac.getConfiguration()).thenReturn(this.conf);
    }

    protected TextVertexInputFormat.TextVertexReader createVertexReader(RecordReader<LongWritable, Text> rr) {
        return this.createVertexReader(rr, null);
    }

    protected TextVertexInputFormat.TextVertexReader createVertexReader(final RecordReader<LongWritable, Text> rr, AdjacencyListTextVertexInputFormat.LineSanitizer lineSanitizer) {
        return new TextDoubleDoubleAdjacencyListVertexInputFormat.TextDoubleDoubleAdjacencyListVertexReader(lineSanitizer){

            protected RecordReader<LongWritable, Text> createLineRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
                return rr;
            }
        };
    }

    @Test
    public void testIndexMustHaveValue() throws IOException, InterruptedException {
        String input = "hi";
        Mockito.when((Object)this.rr.getCurrentValue()).thenReturn((Object)new Text(input));
        TextVertexInputFormat.TextVertexReader vr = this.createVertexReader(this.rr);
        vr.setConf(this.conf);
        vr.initialize(null, this.tac);
        try {
            vr.nextVertex();
            vr.getCurrentVertex();
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().startsWith("Line did not split correctly: "));
        }
    }

    @Test
    public void testEdgesMustHaveValues() throws IOException, InterruptedException {
        String input = "index\t55.66\tindex2";
        Mockito.when((Object)this.rr.getCurrentValue()).thenReturn((Object)new Text(input));
        TextVertexInputFormat.TextVertexReader vr = this.createVertexReader(this.rr);
        vr.setConf(this.conf);
        vr.initialize(null, this.tac);
        try {
            vr.nextVertex();
            vr.getCurrentVertex();
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().startsWith("Line did not split correctly: "));
        }
    }

    public static <I extends WritableComparable, V extends Writable, E extends WritableComparable> void assertValidVertex(ImmutableClassesGiraphConfiguration<I, V, E> conf, Vertex<I, V, E> actual, I expectedId, V expectedValue, Edge<I, E> ... edges) throws Exception {
        Vertex expected = conf.createVertex();
        expected.initialize(expectedId, expectedValue, Arrays.asList(edges));
        TestTextDoubleDoubleAdjacencyListVertexInputFormat.assertValid(expected, actual);
    }

    public static <I extends WritableComparable, V extends Writable, E extends WritableComparable> void assertValid(Vertex<I, V, E> expected, Vertex<I, V, E> actual) {
        Assert.assertEquals((Object)expected.getId(), (Object)actual.getId());
        Assert.assertEquals((Object)expected.getValue(), (Object)actual.getValue());
        Assert.assertTrue((boolean)EdgeIterables.equals((Iterable)expected.getEdges(), (Iterable)actual.getEdges()));
    }

    @Test
    public void testHappyPath() throws Exception {
        String input = "Hi\t0\tCiao\t1.123\tBomdia\t2.234\tOla\t3.345";
        Mockito.when((Object)this.rr.getCurrentValue()).thenReturn((Object)new Text(input));
        TextVertexInputFormat.TextVertexReader vr = this.createVertexReader(this.rr);
        vr.setConf(this.conf);
        vr.initialize(null, this.tac);
        Assert.assertTrue((String)"Should have been able to add a vertex", (boolean)vr.nextVertex());
        Vertex vertex = vr.getCurrentVertex();
        TestTextDoubleDoubleAdjacencyListVertexInputFormat.assertValidVertex(this.conf, vertex, new Text("Hi"), new DoubleWritable(0.0), EdgeFactory.create((WritableComparable)new Text("Ciao"), (Writable)new DoubleWritable(1.123)), EdgeFactory.create((WritableComparable)new Text("Bomdia"), (Writable)new DoubleWritable(2.234)), EdgeFactory.create((WritableComparable)new Text("Ola"), (Writable)new DoubleWritable(3.345)));
        Assert.assertEquals((long)vertex.getNumEdges(), (long)3L);
    }

    @Test
    public void testLineSanitizer() throws Exception {
        String input = "Bye\t0.01\tCiao\t1.001\tTchau\t2.0001\tAdios\t3.00001";
        AdjacencyListTextVertexInputFormat.LineSanitizer toUpper = new AdjacencyListTextVertexInputFormat.LineSanitizer(){

            public String sanitize(String s) {
                return s.toUpperCase();
            }
        };
        Mockito.when((Object)this.rr.getCurrentValue()).thenReturn((Object)new Text(input));
        TextVertexInputFormat.TextVertexReader vr = this.createVertexReader(this.rr, toUpper);
        vr.setConf(this.conf);
        vr.initialize(null, this.tac);
        Assert.assertTrue((String)"Should have been able to read vertex", (boolean)vr.nextVertex());
        Vertex vertex = vr.getCurrentVertex();
        TestTextDoubleDoubleAdjacencyListVertexInputFormat.assertValidVertex(this.conf, vertex, new Text("BYE"), new DoubleWritable(0.01), EdgeFactory.create((WritableComparable)new Text("CIAO"), (Writable)new DoubleWritable(1.001)), EdgeFactory.create((WritableComparable)new Text("TCHAU"), (Writable)new DoubleWritable(2.0001)), EdgeFactory.create((WritableComparable)new Text("ADIOS"), (Writable)new DoubleWritable(3.00001)));
        Assert.assertEquals((long)vertex.getNumEdges(), (long)3L);
    }

    @Test
    public void testDifferentSeparators() throws Exception {
        String input = "alpha:42:beta:99";
        Mockito.when((Object)this.rr.getCurrentValue()).thenReturn((Object)new Text(input));
        this.conf.set("adj.list.input.delimiter", ":");
        TextVertexInputFormat.TextVertexReader vr = this.createVertexReader(this.rr);
        vr.setConf(this.conf);
        vr.initialize(null, this.tac);
        Assert.assertTrue((String)"Should have been able to read vertex", (boolean)vr.nextVertex());
        Vertex vertex = vr.getCurrentVertex();
        TestTextDoubleDoubleAdjacencyListVertexInputFormat.assertValidVertex(this.conf, vertex, new Text("alpha"), new DoubleWritable(42.0), EdgeFactory.create((WritableComparable)new Text("beta"), (Writable)new DoubleWritable(99.0)));
        Assert.assertEquals((long)vertex.getNumEdges(), (long)1L);
    }

    public static class DummyComputation
    extends NoOpComputation<Text, DoubleWritable, DoubleWritable, BooleanWritable> {
    }
}

