/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import java.io.IOException;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.formats.SrcIdDstIdEdgeValueTextOutputFormat;
import org.apache.giraph.utils.NoOpComputation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSrcIdDstIdEdgeValueTextOutputFormat
extends SrcIdDstIdEdgeValueTextOutputFormat<LongWritable, LongWritable, LongWritable> {
    private ImmutableClassesGiraphConfiguration<LongWritable, LongWritable, LongWritable> conf;

    @Before
    public void setUp() {
        GiraphConfiguration giraphConfiguration = new GiraphConfiguration();
        giraphConfiguration.setComputationClass(DummyComputation.class);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)giraphConfiguration);
    }

    @Test
    public void testHappyPath() throws IOException, InterruptedException {
        Text expected = new Text("0\t1\t5");
        this.checkSrcIdDstIdEdgeValueWorker(expected);
    }

    @Test
    public void testReverseIdAndValue() throws IOException, InterruptedException {
        GiraphConstants.GIRAPH_TEXT_OUTPUT_FORMAT_REVERSE.set(this.conf, true);
        Text expected = new Text("5\t1\t0");
        this.checkSrcIdDstIdEdgeValueWorker(expected);
    }

    @Test
    public void testWithDifferentDelimiter() throws IOException, InterruptedException {
        GiraphConstants.GIRAPH_TEXT_OUTPUT_FORMAT_SEPARATOR.set(this.conf, "->");
        Text expected = new Text("0->1->5");
        this.checkSrcIdDstIdEdgeValueWorker(expected);
    }

    private void checkSrcIdDstIdEdgeValueWorker(Text expected) throws IOException, InterruptedException {
        TaskAttemptContext tac = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)tac.getConfiguration()).thenReturn(this.conf);
        Edge edge = (Edge)Mockito.mock(Edge.class);
        Mockito.when((Object)edge.getTargetVertexId()).thenReturn((Object)new LongWritable(1L));
        Mockito.when((Object)edge.getValue()).thenReturn((Object)new LongWritable(5L));
        final RecordWriter tw = (RecordWriter)Mockito.mock(RecordWriter.class);
        SrcIdDstIdEdgeValueTextOutputFormat.SrcIdDstIdEdgeValueEdgeWriter writer = new SrcIdDstIdEdgeValueTextOutputFormat.SrcIdDstIdEdgeValueEdgeWriter(){

            protected RecordWriter<Text, Text> createLineRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
                return tw;
            }
        };
        writer.setConf(this.conf);
        writer.initialize(tac);
        writer.writeEdge((WritableComparable)new LongWritable(0L), (Writable)new LongWritable(0L), edge);
        ((RecordWriter)Mockito.verify((Object)tw)).write((Object)expected, null);
    }

    public static class DummyComputation
    extends NoOpComputation<Text, DoubleWritable, DoubleWritable, DoubleWritable> {
    }
}

