/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import java.io.IOException;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.TestTextDoubleDoubleAdjacencyListVertexInputFormat;
import org.apache.giraph.io.formats.AdjacencyListTextVertexInputFormat;
import org.apache.giraph.io.formats.LongDoubleDoubleAdjacencyListVertexInputFormat;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.giraph.utils.NoOpComputation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestLongDoubleDoubleAdjacencyListVertexInputFormat
extends LongDoubleDoubleAdjacencyListVertexInputFormat {
    private RecordReader<LongWritable, Text> rr;
    private ImmutableClassesGiraphConfiguration<LongWritable, DoubleWritable, DoubleWritable> conf;
    private TaskAttemptContext tac;

    @Before
    public void setUp() throws IOException, InterruptedException {
        this.rr = (RecordReader)Mockito.mock(RecordReader.class);
        Mockito.when((Object)this.rr.nextKeyValue()).thenReturn((Object)true);
        GiraphConfiguration giraphConf = new GiraphConfiguration();
        giraphConf.setComputationClass(DummyComputation.class);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)giraphConf);
        this.tac = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)this.tac.getConfiguration()).thenReturn(this.conf);
    }

    protected TextVertexInputFormat.TextVertexReader createVertexReader(RecordReader<LongWritable, Text> rr) {
        return this.createVertexReader(rr, null);
    }

    protected TextVertexInputFormat.TextVertexReader createVertexReader(final RecordReader<LongWritable, Text> rr, AdjacencyListTextVertexInputFormat.LineSanitizer lineSanitizer) {
        return new LongDoubleDoubleAdjacencyListVertexInputFormat.LongDoubleDoubleAdjacencyListVertexReader(lineSanitizer){

            protected RecordReader<LongWritable, Text> createLineRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
                return rr;
            }
        };
    }

    @Test
    public void testIndexMustHaveValue() throws IOException, InterruptedException {
        String input = "123";
        Mockito.when((Object)this.rr.getCurrentValue()).thenReturn((Object)new Text(input));
        TextVertexInputFormat.TextVertexReader vr = this.createVertexReader(this.rr);
        vr.setConf(this.conf);
        vr.initialize(null, this.tac);
        try {
            vr.nextVertex();
            vr.getCurrentVertex();
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().startsWith("Line did not split correctly: "));
        }
    }

    @Test
    public void testEdgesMustHaveValues() throws IOException, InterruptedException {
        String input = "99\t55.2\t100";
        Mockito.when((Object)this.rr.getCurrentValue()).thenReturn((Object)new Text(input));
        TextVertexInputFormat.TextVertexReader vr = this.createVertexReader(this.rr);
        vr.setConf(this.conf);
        vr.initialize(null, this.tac);
        try {
            vr.nextVertex();
            vr.getCurrentVertex();
            Assert.fail((String)"Should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((boolean)iae.getMessage().startsWith("Line did not split correctly: "));
        }
    }

    @Test
    public void testHappyPath() throws Exception {
        String input = "42\t0.1\t99\t0.2\t2000\t0.3\t4000\t0.4";
        Mockito.when((Object)this.rr.getCurrentValue()).thenReturn((Object)new Text(input));
        TextVertexInputFormat.TextVertexReader vr = this.createVertexReader(this.rr);
        vr.setConf(this.conf);
        vr.initialize(null, this.tac);
        Assert.assertTrue((String)"Should have been able to read vertex", (boolean)vr.nextVertex());
        Vertex vertex = vr.getCurrentVertex();
        TestTextDoubleDoubleAdjacencyListVertexInputFormat.assertValidVertex(this.conf, vertex, new LongWritable(42L), new DoubleWritable(0.1), EdgeFactory.create((WritableComparable)new LongWritable(99L), (Writable)new DoubleWritable(0.2)), EdgeFactory.create((WritableComparable)new LongWritable(2000L), (Writable)new DoubleWritable(0.3)), EdgeFactory.create((WritableComparable)new LongWritable(4000L), (Writable)new DoubleWritable(0.4)));
        Assert.assertEquals((long)vertex.getNumEdges(), (long)3L);
    }

    @Test
    public void testDifferentSeparators() throws Exception {
        String input = "12345:42.42:9999999:99.9";
        Mockito.when((Object)this.rr.getCurrentValue()).thenReturn((Object)new Text(input));
        this.conf.set("adj.list.input.delimiter", ":");
        TextVertexInputFormat.TextVertexReader vr = this.createVertexReader(this.rr);
        vr.setConf(this.conf);
        vr.initialize(null, this.tac);
        Assert.assertTrue((String)"Should have been able to read vertex", (boolean)vr.nextVertex());
        Vertex vertex = vr.getCurrentVertex();
        TestTextDoubleDoubleAdjacencyListVertexInputFormat.assertValidVertex(this.conf, vertex, new LongWritable(12345L), new DoubleWritable(42.42), EdgeFactory.create((WritableComparable)new LongWritable(9999999L), (Writable)new DoubleWritable(99.9)));
        Assert.assertEquals((long)vertex.getNumEdges(), (long)1L);
    }

    public static class DummyComputation
    extends NoOpComputation<LongWritable, DoubleWritable, DoubleWritable, BooleanWritable> {
    }
}

