/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import java.io.IOException;
import org.apache.giraph.BspCase;
import org.apache.giraph.benchmark.WeightedPageRankComputation;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.io.formats.GiraphFileInputFormat;
import org.apache.giraph.io.formats.JsonBase64VertexInputFormat;
import org.apache.giraph.io.formats.JsonBase64VertexOutputFormat;
import org.apache.giraph.io.formats.PseudoRandomVertexInputFormat;
import org.apache.giraph.job.GiraphJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class TestJsonBase64Format
extends BspCase {
    public TestJsonBase64Format() {
        super(TestJsonBase64Format.class.getName());
    }

    @Test
    public void testContinue() throws IOException, InterruptedException, ClassNotFoundException {
        Path outputPath = this.getTempPath(TestJsonBase64Format.getCallingMethodName());
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(WeightedPageRankComputation.class);
        conf.setVertexInputFormatClass(PseudoRandomVertexInputFormat.class);
        conf.setVertexOutputFormatClass(JsonBase64VertexOutputFormat.class);
        GiraphJob job = this.prepareJob(TestJsonBase64Format.getCallingMethodName(), conf, outputPath);
        job.getConfiguration().setLong("giraph.pseudoRandomInputFormat.aggregateVertices", 101L);
        job.getConfiguration().setLong("giraph.pseudoRandomInputFormat.edgesPerVertex", 2L);
        job.getConfiguration().setInt("giraph.weightedPageRank.superstepCount", 2);
        Assert.assertTrue((boolean)job.run(true));
        Path outputPath2 = this.getTempPath(TestJsonBase64Format.getCallingMethodName() + "2");
        conf = new GiraphConfiguration();
        conf.setComputationClass(WeightedPageRankComputation.class);
        conf.setVertexInputFormatClass(JsonBase64VertexInputFormat.class);
        conf.setVertexOutputFormatClass(JsonBase64VertexOutputFormat.class);
        job = this.prepareJob(TestJsonBase64Format.getCallingMethodName(), conf, outputPath2);
        job.getConfiguration().setInt("giraph.weightedPageRank.superstepCount", 3);
        GiraphFileInputFormat.addVertexInputPath((Configuration)job.getInternalJob().getConfiguration(), (Path)outputPath);
        Assert.assertTrue((boolean)job.run(true));
        Path outputPath3 = this.getTempPath(TestJsonBase64Format.getCallingMethodName() + "3");
        conf = new GiraphConfiguration();
        conf.setComputationClass(WeightedPageRankComputation.class);
        conf.setVertexInputFormatClass(PseudoRandomVertexInputFormat.class);
        conf.setVertexOutputFormatClass(JsonBase64VertexOutputFormat.class);
        job = this.prepareJob(TestJsonBase64Format.getCallingMethodName(), conf, outputPath3);
        conf = job.getConfiguration();
        conf.setLong("giraph.pseudoRandomInputFormat.aggregateVertices", 101L);
        conf.setLong("giraph.pseudoRandomInputFormat.edgesPerVertex", 2L);
        conf.setInt("giraph.weightedPageRank.superstepCount", 5);
        Assert.assertTrue((boolean)job.run(true));
        Assert.assertEquals((long)101L, (long)this.getNumResults((Configuration)conf, outputPath));
        Assert.assertEquals((long)101L, (long)this.getNumResults((Configuration)conf, outputPath2));
        Assert.assertEquals((long)101L, (long)this.getNumResults((Configuration)conf, outputPath3));
    }
}

