/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.IdWithValueTextOutputFormat;
import org.apache.giraph.utils.NoOpComputation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestIdWithValueTextOutputFormat
extends IdWithValueTextOutputFormat<Text, DoubleWritable, Writable> {
    private ImmutableClassesGiraphConfiguration<Text, DoubleWritable, Writable> conf;

    @Before
    public void setUp() {
        GiraphConfiguration giraphConfiguration = new GiraphConfiguration();
        giraphConfiguration.setComputationClass(DummyComputation.class);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)giraphConfiguration);
    }

    @Test
    public void testHappyPath() throws IOException, InterruptedException {
        Text expected = new Text("Four Tops\t4.0");
        this.IdWithValueTestWorker(expected);
    }

    @Test
    public void testReverseIdAndValue() throws IOException, InterruptedException {
        this.conf.setBoolean("reverse.id.and.value", true);
        Text expected = new Text("4.0\tFour Tops");
        this.IdWithValueTestWorker(expected);
    }

    @Test
    public void testWithDifferentDelimiter() throws IOException, InterruptedException {
        this.conf.set("output.delimiter", "blah");
        Text expected = new Text("Four Topsblah4.0");
        this.IdWithValueTestWorker(expected);
    }

    private void IdWithValueTestWorker(Text expected) throws IOException, InterruptedException {
        TaskAttemptContext tac = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)tac.getConfiguration()).thenReturn(this.conf);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        Mockito.when((Object)vertex.getId()).thenReturn((Object)new Text("Four Tops"));
        Mockito.when((Object)vertex.getValue()).thenReturn((Object)new DoubleWritable(4.0));
        Mockito.when((Object)vertex.getEdges()).thenReturn(new ArrayList());
        final RecordWriter tw = (RecordWriter)Mockito.mock(RecordWriter.class);
        IdWithValueTextOutputFormat.IdWithValueVertexWriter writer = new IdWithValueTextOutputFormat.IdWithValueVertexWriter(){

            protected RecordWriter<Text, Text> createLineRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
                return tw;
            }
        };
        writer.setConf(this.conf);
        writer.initialize(tac);
        writer.writeVertex(vertex);
        ((RecordWriter)Mockito.verify((Object)tw)).write((Object)expected, null);
        ((Vertex)Mockito.verify((Object)vertex, (VerificationMode)Mockito.times((int)0))).getEdges();
    }

    public static class DummyComputation
    extends NoOpComputation<Text, DoubleWritable, DoubleWritable, DoubleWritable> {
    }
}

