/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.giraph.BspCase;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.filters.EdgeInputFilter;
import org.apache.giraph.io.filters.VertexInputFilter;
import org.apache.giraph.io.formats.IdWithValueTextOutputFormat;
import org.apache.giraph.io.formats.IntIntTextVertexValueInputFormat;
import org.apache.giraph.io.formats.IntNullTextEdgeInputFormat;
import org.apache.giraph.utils.ComputationCountEdges;
import org.apache.giraph.utils.IntNoOpComputation;
import org.apache.giraph.utils.InternalVertexRunner;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestFilters
extends BspCase {
    public TestFilters() {
        super(TestFilters.class.getName());
    }

    @Test
    public void testEdgeFilter() throws Exception {
        String[] edges = new String[]{"1 2", "2 3", "2 4", "4 1"};
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(ComputationCountEdges.class);
        conf.setEdgeInputFormatClass(IntNullTextEdgeInputFormat.class);
        conf.setEdgeInputFilterClass(EdgeFilter.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, null, (String[])edges);
        Map<Integer, Integer> values = TestFilters.parseResults(results);
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((long)1L, (long)values.get(1).intValue());
        Assert.assertEquals((long)1L, (long)values.get(4).intValue());
    }

    @Test
    public void testVertexFilter() throws Exception {
        String[] vertices = new String[]{"1 1", "2 2", "3 3", "4 4"};
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(IntNoOpComputation.class);
        conf.setVertexInputFormatClass(IntIntTextVertexValueInputFormat.class);
        conf.setVertexInputFilterClass(VertexFilter.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices);
        Map<Integer, Integer> values = TestFilters.parseResults(results);
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((long)1L, (long)values.get(1).intValue());
        Assert.assertEquals((long)4L, (long)values.get(4).intValue());
    }

    private static Map<Integer, Integer> parseResults(Iterable<String> results) {
        HashMap values = Maps.newHashMap();
        for (String line : results) {
            String[] tokens = line.split("\\s+");
            int id = Integer.valueOf(tokens[0]);
            int value = Integer.valueOf(tokens[1]);
            values.put(id, value);
        }
        return values;
    }

    public static class VertexFilter
    implements VertexInputFilter<IntWritable, NullWritable, NullWritable> {
        public boolean dropVertex(Vertex<IntWritable, NullWritable, NullWritable> vertex) {
            int id = ((IntWritable)vertex.getId()).get();
            return id == 2 || id == 3;
        }
    }

    public static class EdgeFilter
    implements EdgeInputFilter<IntWritable, NullWritable> {
        public boolean dropEdge(IntWritable sourceId, Edge<IntWritable, NullWritable> edge) {
            return sourceId.get() == 2;
        }
    }
}

