/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.io.formats.IdWithValueTextOutputFormat;
import org.apache.giraph.io.formats.IntIntNullTextVertexInputFormat;
import org.apache.giraph.io.formats.IntNullTextEdgeInputFormat;
import org.apache.giraph.utils.ComputationCountEdges;
import org.apache.giraph.utils.IntIntNullNoOpComputation;
import org.apache.giraph.utils.InternalVertexRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestCreateSourceVertex {
    @Test
    public void testPositiveCreateSourceVertex() throws Exception {
        String[] vertices = new String[]{"1 0", "2 0", "3 0", "4 0"};
        String[] edges = new String[]{"1 2", "1 5", "2 4", "2 1", "3 4", "4 1", "4 5", "6 2", "7 8", "4 8"};
        GiraphConfiguration conf = this.getConf();
        conf.setCreateSourceVertex(false);
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        Map<Integer, Integer> values = TestCreateSourceVertex.parseResults(results);
        Assert.assertEquals((long)4L, (long)values.size());
        Assert.assertTrue((boolean)values.containsKey(1));
        Assert.assertTrue((boolean)values.containsKey(2));
        Assert.assertTrue((boolean)values.containsKey(3));
        Assert.assertTrue((boolean)values.containsKey(4));
        conf.setComputationClass(ComputationCountEdges.class);
        results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        values = TestCreateSourceVertex.parseResults(results);
        Assert.assertEquals((long)2L, (long)values.get(1).intValue());
        Assert.assertEquals((long)2L, (long)values.get(2).intValue());
        Assert.assertEquals((long)1L, (long)values.get(3).intValue());
        Assert.assertEquals((long)3L, (long)values.get(4).intValue());
    }

    @Test
    public void testNegativeCreateSourceVertex() throws Exception {
        String[] vertices = new String[]{"1 0", "2 0", "3 0", "4 0"};
        String[] edges = new String[]{"1 2", "1 5", "2 4", "2 1", "3 4", "4 1", "4 5", "6 2", "7 8", "4 8"};
        GiraphConfiguration conf = this.getConf();
        Iterable results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        Map<Integer, Integer> values = TestCreateSourceVertex.parseResults(results);
        Assert.assertEquals((long)6L, (long)values.size());
        Assert.assertTrue((boolean)values.containsKey(1));
        Assert.assertTrue((boolean)values.containsKey(2));
        Assert.assertTrue((boolean)values.containsKey(3));
        Assert.assertTrue((boolean)values.containsKey(4));
        Assert.assertTrue((boolean)values.containsKey(6));
        Assert.assertTrue((boolean)values.containsKey(7));
        conf.setComputationClass(ComputationCountEdges.class);
        results = InternalVertexRunner.run((GiraphConfiguration)conf, (String[])vertices, (String[])edges);
        values = TestCreateSourceVertex.parseResults(results);
        Assert.assertEquals((long)2L, (long)values.get(1).intValue());
        Assert.assertEquals((long)2L, (long)values.get(2).intValue());
        Assert.assertEquals((long)1L, (long)values.get(3).intValue());
        Assert.assertEquals((long)3L, (long)values.get(4).intValue());
        Assert.assertEquals((long)1L, (long)values.get(6).intValue());
        Assert.assertEquals((long)1L, (long)values.get(7).intValue());
    }

    private GiraphConfiguration getConf() {
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setComputationClass(IntIntNullNoOpComputation.class);
        conf.setOutEdgesClass(ByteArrayEdges.class);
        conf.setVertexInputFormatClass(IntIntNullTextVertexInputFormat.class);
        conf.setEdgeInputFormatClass(IntNullTextEdgeInputFormat.class);
        conf.setVertexOutputFormatClass(IdWithValueTextOutputFormat.class);
        return conf;
    }

    private static Map<Integer, Integer> parseResults(Iterable<String> results) {
        HashMap values = Maps.newHashMap();
        for (String line : results) {
            String[] tokens = line.split("\\s+");
            int id = Integer.valueOf(tokens[0]);
            int value = Integer.valueOf(tokens[1]);
            values.put(id, value);
        }
        return values;
    }
}

