/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.AdjacencyListTextVertexOutputFormat;
import org.apache.giraph.utils.NoOpComputation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAdjacencyListTextVertexOutputFormat
extends AdjacencyListTextVertexOutputFormat<Text, DoubleWritable, DoubleWritable> {
    private ImmutableClassesGiraphConfiguration<Text, DoubleWritable, DoubleWritable> conf;

    @Before
    public void setUp() {
        GiraphConfiguration giraphConfiguration = new GiraphConfiguration();
        giraphConfiguration.setComputationClass(DummyComputation.class);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)giraphConfiguration);
    }

    protected AdjacencyListTextVertexOutputFormat.AdjacencyListTextVertexWriter createVertexWriter(final RecordWriter<Text, Text> tw) {
        AdjacencyListTextVertexOutputFormat.AdjacencyListTextVertexWriter writer = new AdjacencyListTextVertexOutputFormat.AdjacencyListTextVertexWriter(){

            protected RecordWriter<Text, Text> createLineRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
                return tw;
            }
        };
        return writer;
    }

    @Test
    public void testVertexWithNoEdges() throws IOException, InterruptedException {
        TaskAttemptContext tac = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)tac.getConfiguration()).thenReturn(this.conf);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        Mockito.when((Object)vertex.getId()).thenReturn((Object)new Text("The Beautiful South"));
        Mockito.when((Object)vertex.getValue()).thenReturn((Object)new DoubleWritable(32.2));
        Mockito.when((Object)vertex.getEdges()).thenReturn(new ArrayList());
        RecordWriter tw = (RecordWriter)Mockito.mock(RecordWriter.class);
        AdjacencyListTextVertexOutputFormat.AdjacencyListTextVertexWriter writer = this.createVertexWriter((RecordWriter<Text, Text>)tw);
        writer.setConf(this.conf);
        writer.initialize(tac);
        writer.writeVertex(vertex);
        Text expected = new Text("The Beautiful South\t32.2");
        ((RecordWriter)Mockito.verify((Object)tw)).write((Object)expected, null);
        ((Vertex)Mockito.verify((Object)vertex, (VerificationMode)Mockito.times((int)1))).getEdges();
    }

    @Test
    public void testVertexWithEdges() throws IOException, InterruptedException {
        TaskAttemptContext tac = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)tac.getConfiguration()).thenReturn(this.conf);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        Mockito.when((Object)vertex.getId()).thenReturn((Object)new Text("San Francisco"));
        Mockito.when((Object)vertex.getValue()).thenReturn((Object)new DoubleWritable(0.0));
        ArrayList cities = Lists.newArrayList();
        Collections.addAll(cities, EdgeFactory.create((WritableComparable)new Text("Los Angeles"), (Writable)new DoubleWritable(347.16)), EdgeFactory.create((WritableComparable)new Text("Phoenix"), (Writable)new DoubleWritable(652.48)));
        Mockito.when((Object)vertex.getEdges()).thenReturn((Object)cities);
        RecordWriter tw = (RecordWriter)Mockito.mock(RecordWriter.class);
        AdjacencyListTextVertexOutputFormat.AdjacencyListTextVertexWriter writer = this.createVertexWriter((RecordWriter<Text, Text>)tw);
        writer.setConf(this.conf);
        writer.initialize(tac);
        writer.writeVertex(vertex);
        Text expected = new Text("San Francisco\t0.0\tLos Angeles\t347.16\tPhoenix\t652.48");
        ((RecordWriter)Mockito.verify((Object)tw)).write((Object)expected, null);
        ((Vertex)Mockito.verify((Object)vertex, (VerificationMode)Mockito.times((int)1))).getEdges();
    }

    @Test
    public void testWithDifferentDelimiter() throws IOException, InterruptedException {
        this.conf.set("output.delimiter", ":::");
        TaskAttemptContext tac = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)tac.getConfiguration()).thenReturn(this.conf);
        Vertex vertex = (Vertex)Mockito.mock(Vertex.class);
        Mockito.when((Object)vertex.getId()).thenReturn((Object)new Text("San Francisco"));
        Mockito.when((Object)vertex.getValue()).thenReturn((Object)new DoubleWritable(0.0));
        ArrayList cities = Lists.newArrayList();
        Collections.addAll(cities, EdgeFactory.create((WritableComparable)new Text("Los Angeles"), (Writable)new DoubleWritable(347.16)), EdgeFactory.create((WritableComparable)new Text("Phoenix"), (Writable)new DoubleWritable(652.48)));
        Mockito.when((Object)vertex.getEdges()).thenReturn((Object)cities);
        RecordWriter tw = (RecordWriter)Mockito.mock(RecordWriter.class);
        AdjacencyListTextVertexOutputFormat.AdjacencyListTextVertexWriter writer = this.createVertexWriter((RecordWriter<Text, Text>)tw);
        writer.setConf(this.conf);
        writer.initialize(tac);
        writer.writeVertex(vertex);
        Text expected = new Text("San Francisco:::0.0:::Los Angeles:::347.16:::Phoenix:::652.48");
        ((RecordWriter)Mockito.verify((Object)tw)).write((Object)expected, null);
        ((Vertex)Mockito.verify((Object)vertex, (VerificationMode)Mockito.times((int)1))).getEdges();
    }

    public static class DummyComputation
    extends NoOpComputation<Text, DoubleWritable, DoubleWritable, DoubleWritable> {
    }
}

