/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.ArrayListEdges;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.HashMapEdges;
import org.apache.giraph.edge.HashMultimapEdges;
import org.apache.giraph.edge.LongDoubleArrayEdges;
import org.apache.giraph.edge.LongDoubleHashMapEdges;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.time.Times;
import org.apache.giraph.utils.DynamicChannelBufferInputStream;
import org.apache.giraph.utils.DynamicChannelBufferOutputStream;
import org.apache.giraph.utils.EdgeIterables;
import org.apache.giraph.utils.NoOpComputation;
import org.apache.giraph.utils.UnsafeByteArrayInputStream;
import org.apache.giraph.utils.UnsafeByteArrayOutputStream;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVertexAndEdges {
    public static final int REPS = 100;
    private Collection<Class<? extends OutEdges>> edgesClasses = Lists.newArrayList();

    @Before
    public void setUp() {
        this.edgesClasses.add(TestOutEdges.class);
        this.edgesClasses.add(ByteArrayEdges.class);
        this.edgesClasses.add(ArrayListEdges.class);
        this.edgesClasses.add(HashMapEdges.class);
        this.edgesClasses.add(HashMultimapEdges.class);
        this.edgesClasses.add(LongDoubleArrayEdges.class);
        this.edgesClasses.add(LongDoubleHashMapEdges.class);
    }

    protected Vertex<LongWritable, FloatWritable, DoubleWritable> instantiateVertex(Class<? extends OutEdges> edgesClass) {
        GiraphConfiguration giraphConfiguration = new GiraphConfiguration();
        giraphConfiguration.setComputationClass(TestComputation.class);
        giraphConfiguration.setOutEdgesClass(edgesClass);
        ImmutableClassesGiraphConfiguration immutableClassesGiraphConfiguration = new ImmutableClassesGiraphConfiguration((Configuration)giraphConfiguration);
        return immutableClassesGiraphConfiguration.createVertex();
    }

    @Test
    public void testVertexIdAndValue() {
        Vertex<LongWritable, FloatWritable, DoubleWritable> vertex = this.instantiateVertex(ArrayListEdges.class);
        Assert.assertNotNull(vertex);
        vertex.initialize((WritableComparable)new LongWritable(7L), (Writable)new FloatWritable(3.0f));
        Assert.assertEquals((long)7L, (long)((LongWritable)vertex.getId()).get());
        Assert.assertEquals((double)3.0, (double)((FloatWritable)vertex.getValue()).get(), (double)0.0);
        vertex.setValue((Writable)new FloatWritable(5.5f));
        Assert.assertEquals((double)5.5, (double)((FloatWritable)vertex.getValue()).get(), (double)0.0);
    }

    public static OutEdges instantiateOutEdges(Class<? extends OutEdges> edgesClass) {
        GiraphConfiguration giraphConfiguration = new GiraphConfiguration();
        giraphConfiguration.setComputationClass(TestComputation.class);
        giraphConfiguration.setOutEdgesClass(edgesClass);
        ImmutableClassesGiraphConfiguration immutableClassesGiraphConfiguration = new ImmutableClassesGiraphConfiguration((Configuration)giraphConfiguration);
        return immutableClassesGiraphConfiguration.createOutEdges();
    }

    @Test
    public void testEdges() {
        for (Class<? extends OutEdges> edgesClass : this.edgesClasses) {
            this.testEdgesClass(edgesClass);
        }
    }

    private void testEdgesClass(Class<? extends OutEdges> edgesClass) {
        Vertex<LongWritable, FloatWritable, DoubleWritable> vertex = this.instantiateVertex(edgesClass);
        OutEdges outEdges = TestVertexAndEdges.instantiateOutEdges(edgesClass);
        Assert.assertNotNull((Object)outEdges);
        LinkedList edges = Lists.newLinkedList();
        for (int i = 1000; i > 0; --i) {
            edges.add(EdgeFactory.create((WritableComparable)new LongWritable((long)i), (Writable)new DoubleWritable((double)i * 2.0)));
        }
        outEdges.initialize((Iterable)edges);
        vertex.initialize((WritableComparable)new LongWritable(1L), (Writable)new FloatWritable(1.0f), (Iterable)outEdges);
        Assert.assertEquals((double)20.0, (double)((DoubleWritable)vertex.getEdgeValue((WritableComparable)new LongWritable(10L))).get(), (double)0.0);
        Assert.assertEquals((long)1000L, (long)vertex.getNumEdges());
        for (Edge edge : vertex.getEdges()) {
            Assert.assertEquals((double)((double)((LongWritable)edge.getTargetVertexId()).get() * 2.0), (double)((DoubleWritable)edge.getValue()).get(), (double)0.0);
        }
        vertex.removeEdges((WritableComparable)new LongWritable(500L));
        Assert.assertEquals((long)999L, (long)vertex.getNumEdges());
        for (Edge edge : vertex.getEdges()) {
            Assert.assertTrue((((LongWritable)edge.getTargetVertexId()).get() != 500L ? 1 : 0) != 0);
        }
        vertex.setEdgeValue((WritableComparable)new LongWritable(10L), (Writable)new DoubleWritable(33.0));
        Assert.assertEquals((double)33.0, (double)((DoubleWritable)vertex.getEdgeValue((WritableComparable)new LongWritable(10L))).get(), (double)0.0);
    }

    @Test
    public void testMutateEdges() {
        for (Class<? extends OutEdges> edgesClass : this.edgesClasses) {
            this.testMutateEdgesClass(edgesClass);
        }
    }

    private void testMutateEdgesClass(Class<? extends OutEdges> edgesClass) {
        Vertex<LongWritable, FloatWritable, DoubleWritable> vertex = this.instantiateVertex(edgesClass);
        OutEdges outEdges = TestVertexAndEdges.instantiateOutEdges(edgesClass);
        outEdges.initialize();
        vertex.initialize((WritableComparable)new LongWritable(0L), (Writable)new FloatWritable(0.0f), (Iterable)outEdges);
        for (int i = 0; i < 10; ++i) {
            vertex.addEdge(EdgeFactory.create((WritableComparable)new LongWritable((long)i), (Writable)new DoubleWritable((double)i)));
        }
        for (MutableEdge edge : vertex.getMutableEdges()) {
            edge.setValue((Writable)new DoubleWritable(((DoubleWritable)edge.getValue()).get() * 2.0));
        }
        Assert.assertEquals((long)10L, (long)vertex.getNumEdges());
        for (MutableEdge edge : vertex.getEdges()) {
            long id = ((LongWritable)edge.getTargetVertexId()).get();
            double value = ((DoubleWritable)edge.getValue()).get();
            Assert.assertEquals((double)(id * 2L), (double)value, (double)0.0);
        }
        Iterator edgeIt = vertex.getMutableEdges().iterator();
        while (edgeIt.hasNext()) {
            if (((LongWritable)((MutableEdge)edgeIt.next()).getTargetVertexId()).get() % 2L != 0L) continue;
            edgeIt.remove();
        }
        Assert.assertEquals((long)5L, (long)vertex.getNumEdges());
        for (Edge edge : vertex.getEdges()) {
            Assert.assertEquals((long)1L, (long)(((LongWritable)edge.getTargetVertexId()).get() % 2L));
        }
        Iterator it = vertex.getMutableEdges().iterator();
        it.next();
        it.next();
        Assert.assertEquals((long)5L, (long)vertex.getNumEdges());
        int i = 2;
        for (MutableEdge edge : vertex.getMutableEdges()) {
            if (i-- != 0) continue;
            break;
        }
        Assert.assertEquals((long)5L, (long)vertex.getNumEdges());
        i = 2;
        for (Edge edge : vertex.getEdges()) {
            if (i-- != 0) continue;
            break;
        }
        Assert.assertEquals((long)5L, (long)vertex.getNumEdges());
        int iterations = 0;
        for (MutableEdge edge : vertex.getMutableEdges()) {
            edge.setValue((Writable)new DoubleWritable(3.0));
            Assert.assertEquals((long)5L, (long)vertex.getNumEdges());
            ++iterations;
        }
        Assert.assertEquals((long)5L, (long)vertex.getNumEdges());
        Assert.assertEquals((long)5L, (long)iterations);
        it = vertex.getMutableEdges().iterator();
        it.next();
        it.remove();
        Assert.assertEquals((long)4L, (long)vertex.getNumEdges());
        it.next();
        it.remove();
        Assert.assertEquals((long)3L, (long)vertex.getNumEdges());
    }

    @Test
    public void testSerialize() throws IOException {
        for (Class<? extends OutEdges> edgesClass : this.edgesClasses) {
            this.testSerializeOutEdgesClass(edgesClass);
            this.testDynamicChannelBufferSerializeOutEdgesClass(edgesClass);
            this.testUnsafeSerializeOutEdgesClass(edgesClass);
        }
    }

    protected Vertex<LongWritable, FloatWritable, DoubleWritable> buildVertex(Class<? extends OutEdges> edgesClass) {
        Vertex<LongWritable, FloatWritable, DoubleWritable> vertex = this.instantiateVertex(edgesClass);
        OutEdges outEdges = TestVertexAndEdges.instantiateOutEdges(edgesClass);
        int edgesCount = 200;
        ArrayList edges = Lists.newArrayListWithCapacity((int)edgesCount);
        for (int i = edgesCount; i > 0; --i) {
            edges.add(EdgeFactory.create((WritableComparable)new LongWritable((long)i), (Writable)new DoubleWritable((double)i * 2.0)));
        }
        outEdges.initialize((Iterable)edges);
        vertex.initialize((WritableComparable)new LongWritable(2L), (Writable)new FloatWritable(3.0f), (Iterable)outEdges);
        return vertex;
    }

    private void testSerializeOutEdgesClass(Class<? extends OutEdges> edgesClass) {
        Vertex<LongWritable, FloatWritable, DoubleWritable> vertex = this.buildVertex(edgesClass);
        long serializeNanos = 0L;
        byte[] byteArray = null;
        for (int i = 0; i < 100; ++i) {
            long serializeNanosStart = SystemTime.get().getNanoseconds();
            byteArray = WritableUtils.writeVertexToByteArray(vertex, (boolean)false, (ImmutableClassesGiraphConfiguration)vertex.getConf());
            serializeNanos += Times.getNanosecondsSince((Time)SystemTime.get(), (long)serializeNanosStart);
        }
        System.out.println("testSerialize: Serializing took " + (serializeNanos /= 100L) + " ns for " + byteArray.length + " bytes " + (float)byteArray.length * 1.0f * 1.0E9f / (float)serializeNanos + " bytes / sec for " + edgesClass.getName());
        Vertex<LongWritable, FloatWritable, DoubleWritable> readVertex = this.buildVertex(edgesClass);
        long deserializeNanos = 0L;
        for (int i = 0; i < 100; ++i) {
            long deserializeNanosStart = SystemTime.get().getNanoseconds();
            WritableUtils.reinitializeVertexFromByteArray((byte[])byteArray, readVertex, (boolean)false, (ImmutableClassesGiraphConfiguration)readVertex.getConf());
            deserializeNanos += Times.getNanosecondsSince((Time)SystemTime.get(), (long)deserializeNanosStart);
        }
        System.out.println("testSerialize: Deserializing took " + (deserializeNanos /= 100L) + " ns for " + byteArray.length + " bytes " + (float)byteArray.length * 1.0f * 1.0E9f / (float)deserializeNanos + " bytes / sec for " + edgesClass.getName());
        Assert.assertEquals((Object)vertex.getId(), (Object)readVertex.getId());
        Assert.assertEquals((Object)vertex.getValue(), (Object)readVertex.getValue());
        Assert.assertTrue((boolean)EdgeIterables.sameEdges((Iterable)vertex.getEdges(), (Iterable)readVertex.getEdges()));
    }

    private void testDynamicChannelBufferSerializeOutEdgesClass(Class<? extends OutEdges> edgesClass) throws IOException {
        Vertex<LongWritable, FloatWritable, DoubleWritable> vertex = this.buildVertex(edgesClass);
        long serializeNanos = 0L;
        DynamicChannelBufferOutputStream outputStream = null;
        for (int i = 0; i < 100; ++i) {
            long serializeNanosStart = SystemTime.get().getNanoseconds();
            outputStream = new DynamicChannelBufferOutputStream(32);
            WritableUtils.writeVertexToDataOutput((DataOutput)outputStream, vertex, (ImmutableClassesGiraphConfiguration)vertex.getConf());
            serializeNanos += Times.getNanosecondsSince((Time)SystemTime.get(), (long)serializeNanosStart);
        }
        System.out.println("testDynamicChannelBufferSerializeOutEdgesClass: Serializing took " + (serializeNanos /= 100L) + " ns for " + outputStream.getDynamicChannelBuffer().writerIndex() + " bytes " + (float)outputStream.getDynamicChannelBuffer().writerIndex() * 1.0f * 1.0E9f / (float)serializeNanos + " bytes / sec for " + edgesClass.getName());
        Vertex<LongWritable, FloatWritable, DoubleWritable> readVertex = this.buildVertex(edgesClass);
        long deserializeNanos = 0L;
        for (int i = 0; i < 100; ++i) {
            long deserializeNanosStart = SystemTime.get().getNanoseconds();
            DynamicChannelBufferInputStream inputStream = new DynamicChannelBufferInputStream(outputStream.getDynamicChannelBuffer());
            WritableUtils.reinitializeVertexFromDataInput((DataInput)inputStream, readVertex, (ImmutableClassesGiraphConfiguration)readVertex.getConf());
            deserializeNanos += Times.getNanosecondsSince((Time)SystemTime.get(), (long)deserializeNanosStart);
            outputStream.getDynamicChannelBuffer().readerIndex(0);
        }
        System.out.println("testDynamicChannelBufferSerializeOutEdgesClass: Deserializing took " + (deserializeNanos /= 100L) + " ns for " + outputStream.getDynamicChannelBuffer().writerIndex() + " bytes " + (float)outputStream.getDynamicChannelBuffer().writerIndex() * 1.0f * 1.0E9f / (float)deserializeNanos + " bytes / sec for " + edgesClass.getName());
        Assert.assertEquals((Object)vertex.getId(), (Object)readVertex.getId());
        Assert.assertEquals((Object)vertex.getValue(), (Object)readVertex.getValue());
        Assert.assertTrue((boolean)EdgeIterables.sameEdges((Iterable)vertex.getEdges(), (Iterable)readVertex.getEdges()));
    }

    private void testUnsafeSerializeOutEdgesClass(Class<? extends OutEdges> edgesClass) throws IOException {
        Vertex<LongWritable, FloatWritable, DoubleWritable> vertex = this.buildVertex(edgesClass);
        long serializeNanos = 0L;
        UnsafeByteArrayOutputStream outputStream = null;
        for (int i = 0; i < 100; ++i) {
            long serializeNanosStart = SystemTime.get().getNanoseconds();
            outputStream = new UnsafeByteArrayOutputStream(32);
            WritableUtils.writeVertexToDataOutput((DataOutput)outputStream, vertex, (ImmutableClassesGiraphConfiguration)vertex.getConf());
            serializeNanos += Times.getNanosecondsSince((Time)SystemTime.get(), (long)serializeNanosStart);
        }
        System.out.println("testUnsafeSerializeOutEdgesClass: Serializing took " + (serializeNanos /= 100L) + " ns for " + outputStream.getPos() + " bytes " + (float)outputStream.getPos() * 1.0f * 1.0E9f / (float)serializeNanos + " bytes / sec for " + edgesClass.getName());
        Vertex<LongWritable, FloatWritable, DoubleWritable> readVertex = this.buildVertex(edgesClass);
        long deserializeNanos = 0L;
        for (int i = 0; i < 100; ++i) {
            long deserializeNanosStart = SystemTime.get().getNanoseconds();
            UnsafeByteArrayInputStream inputStream = new UnsafeByteArrayInputStream(outputStream.getByteArray(), 0, outputStream.getPos());
            WritableUtils.reinitializeVertexFromDataInput((DataInput)inputStream, readVertex, (ImmutableClassesGiraphConfiguration)readVertex.getConf());
            deserializeNanos += Times.getNanosecondsSince((Time)SystemTime.get(), (long)deserializeNanosStart);
        }
        System.out.println("testUnsafeSerializeOutEdgesClass: Deserializing took " + (deserializeNanos /= 100L) + " ns for " + outputStream.getPos() + " bytes " + (float)outputStream.getPos() * 1.0f * 1.0E9f / (float)deserializeNanos + " bytes / sec for " + edgesClass.getName());
        Assert.assertEquals((Object)vertex.getId(), (Object)readVertex.getId());
        Assert.assertEquals((Object)vertex.getValue(), (Object)readVertex.getValue());
        Assert.assertTrue((boolean)EdgeIterables.sameEdges((Iterable)vertex.getEdges(), (Iterable)readVertex.getEdges()));
    }

    public static class TestOutEdges
    implements OutEdges<LongWritable, DoubleWritable> {
        private List<Edge<LongWritable, DoubleWritable>> edgeList;

        public void initialize(Iterable<Edge<LongWritable, DoubleWritable>> edges) {
            this.edgeList = Lists.newArrayList(edges);
        }

        public void initialize(int capacity) {
            this.edgeList = Lists.newArrayListWithCapacity((int)capacity);
        }

        public void initialize() {
            this.edgeList = Lists.newArrayList();
        }

        public void add(Edge<LongWritable, DoubleWritable> edge) {
            this.edgeList.add(edge);
        }

        public void remove(LongWritable targetVertexId) {
            Iterator<Edge<LongWritable, DoubleWritable>> edges = this.edgeList.iterator();
            while (edges.hasNext()) {
                Edge<LongWritable, DoubleWritable> edge = edges.next();
                if (!((LongWritable)edge.getTargetVertexId()).equals((Object)targetVertexId)) continue;
                edges.remove();
            }
        }

        public int size() {
            return this.edgeList.size();
        }

        public Iterator<Edge<LongWritable, DoubleWritable>> iterator() {
            return this.edgeList.iterator();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.edgeList.size());
            for (Edge<LongWritable, DoubleWritable> edge : this.edgeList) {
                ((LongWritable)edge.getTargetVertexId()).write(out);
                ((DoubleWritable)edge.getValue()).write(out);
            }
        }

        public void readFields(DataInput in) throws IOException {
            int numEdges = in.readInt();
            this.initialize(numEdges);
            for (int i = 0; i < numEdges; ++i) {
                ReusableEdge edge = EdgeFactory.createReusable((WritableComparable)new LongWritable(), (Writable)new DoubleWritable());
                WritableUtils.readEdge((DataInput)in, (Edge)edge);
                this.edgeList.add((Edge<LongWritable, DoubleWritable>)edge);
            }
        }
    }

    public static class TestComputation
    extends NoOpComputation<LongWritable, FloatWritable, DoubleWritable, LongWritable> {
    }
}

