/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.graph;

import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.ArrayListEdges;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.ByteValueVertex;
import org.apache.giraph.graph.TestVertexAndEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestByteValueVertex
extends TestVertexAndEdges {
    @Override
    protected Vertex<LongWritable, FloatWritable, DoubleWritable> instantiateVertex(Class<? extends OutEdges> edgesClass) {
        GiraphConfiguration giraphConfiguration = new GiraphConfiguration();
        giraphConfiguration.setComputationClass(TestVertexAndEdges.TestComputation.class);
        giraphConfiguration.setOutEdgesClass(edgesClass);
        giraphConfiguration.setVertexClass(ByteValueVertex.class);
        ImmutableClassesGiraphConfiguration immutableClassesGiraphConfiguration = new ImmutableClassesGiraphConfiguration((Configuration)giraphConfiguration);
        Vertex bv = immutableClassesGiraphConfiguration.createVertex();
        Assert.assertTrue((boolean)(bv instanceof ByteValueVertex));
        return bv;
    }

    @Test
    public void testCachedValue() {
        ByteValueVertex byteValueVertex = (ByteValueVertex)this.instantiateVertex(ArrayListEdges.class);
        FloatWritable origValue = new FloatWritable(492.2f);
        byteValueVertex.setValue((Writable)origValue);
        Assert.assertEquals((float)492.2f, (float)((FloatWritable)byteValueVertex.getValue()).get(), (float)0.0f);
        FloatWritable gotValue = (FloatWritable)byteValueVertex.getValue();
        gotValue.set(33.3f);
        Assert.assertEquals((float)33.3f, (float)((FloatWritable)byteValueVertex.getValue()).get(), (float)0.0f);
        FloatWritable newValue = new FloatWritable(99.9f);
        byteValueVertex.setValue((Writable)newValue);
        Assert.assertEquals((float)99.9f, (float)((FloatWritable)byteValueVertex.getValue()).get(), (float)0.0f);
        Assert.assertTrue((newValue == byteValueVertex.getValue() ? 1 : 0) != 0);
        byteValueVertex.unwrapMutableEdges();
        Assert.assertFalse((newValue == byteValueVertex.getValue() ? 1 : 0) != 0);
        Assert.assertEquals((float)99.9f, (float)((FloatWritable)byteValueVertex.getValue()).get(), (float)0.0f);
    }
}

