/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.HashMapEdges;
import org.apache.giraph.edge.LongDoubleHashMapEdges;
import org.apache.giraph.edge.StrictRandomAccessOutEdges;
import org.apache.giraph.graph.TestVertexAndEdges;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestStrictRandomAccessEdges {
    private Collection<Class<? extends StrictRandomAccessOutEdges>> edgesClasses = Lists.newArrayList();

    @Before
    public void setUp() {
        this.edgesClasses.add(HashMapEdges.class);
        this.edgesClasses.add(LongDoubleHashMapEdges.class);
    }

    @Test
    public void testParallelEdges() {
        for (Class<? extends StrictRandomAccessOutEdges> edgesClass : this.edgesClasses) {
            this.testParallelEdgesClass(edgesClass);
        }
    }

    private void testParallelEdgesClass(Class<? extends StrictRandomAccessOutEdges> edgesClass) {
        StrictRandomAccessOutEdges edges = (StrictRandomAccessOutEdges)TestVertexAndEdges.instantiateOutEdges(edgesClass);
        ArrayList initialEdges = Lists.newArrayList((Object[])new Edge[]{EdgeFactory.create((WritableComparable)new LongWritable(1L), (Writable)new DoubleWritable(1.0)), EdgeFactory.create((WritableComparable)new LongWritable(2L), (Writable)new DoubleWritable(2.0)), EdgeFactory.create((WritableComparable)new LongWritable(3L), (Writable)new DoubleWritable(3.0)), EdgeFactory.create((WritableComparable)new LongWritable(2L), (Writable)new DoubleWritable(20.0))});
        edges.initialize((Iterable)initialEdges);
        Assert.assertEquals((double)3.0, (double)((DoubleWritable)edges.getEdgeValue((WritableComparable)new LongWritable(3L))).get(), (double)0.0);
        Assert.assertNull((Object)edges.getEdgeValue((WritableComparable)new LongWritable(55L)));
        edges.setEdgeValue((WritableComparable)new LongWritable(2L), (Writable)new DoubleWritable(33.0));
        Assert.assertEquals((double)33.0, (double)((DoubleWritable)edges.getEdgeValue((WritableComparable)new LongWritable(2L))).get(), (double)0.0);
    }
}

