/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.LongNullArrayEdges;
import org.apache.giraph.edge.LongNullHashSetEdges;
import org.apache.giraph.edge.MutableEdge;
import org.apache.giraph.edge.MutableOutEdges;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.TestVertexAndEdges;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNullValueEdges {
    private Collection<Class<? extends MutableOutEdges>> edgesClasses = Lists.newArrayList();

    @Before
    public void setUp() {
        this.edgesClasses.add(LongNullArrayEdges.class);
        this.edgesClasses.add(LongNullHashSetEdges.class);
    }

    @Test
    public void testEdges() {
        for (Class<? extends MutableOutEdges> edgesClass : this.edgesClasses) {
            this.testEdgesClass(edgesClass);
        }
    }

    private void testEdgesClass(Class<? extends OutEdges> edgesClass) {
        OutEdges edges = TestVertexAndEdges.instantiateOutEdges(edgesClass);
        ArrayList initialEdges = Lists.newArrayList((Object[])new Edge[]{EdgeFactory.create((WritableComparable)new LongWritable(1L)), EdgeFactory.create((WritableComparable)new LongWritable(2L)), EdgeFactory.create((WritableComparable)new LongWritable(3L))});
        edges.initialize((Iterable)initialEdges);
        Assert.assertEquals((long)3L, (long)edges.size());
        edges.add((Edge)EdgeFactory.createReusable((WritableComparable)new LongWritable(4L)));
        Assert.assertEquals((long)4L, (long)edges.size());
        edges.remove((WritableComparable)new LongWritable(2L));
        Assert.assertEquals((long)3L, (long)edges.size());
    }

    @Test
    public void testMutateEdges() {
        for (Class<? extends MutableOutEdges> edgesClass : this.edgesClasses) {
            this.testMutateEdgesClass(edgesClass);
        }
    }

    private void testMutateEdgesClass(Class<? extends MutableOutEdges> edgesClass) {
        MutableOutEdges edges = (MutableOutEdges)TestVertexAndEdges.instantiateOutEdges(edgesClass);
        edges.initialize();
        for (int i = 0; i < 10; ++i) {
            edges.add(EdgeFactory.create((WritableComparable)new LongWritable((long)i)));
        }
        Iterator edgeIt = edges.mutableIterator();
        while (edgeIt.hasNext()) {
            if (((LongWritable)((MutableEdge)edgeIt.next()).getTargetVertexId()).get() % 2L != 0L) continue;
            edgeIt.remove();
        }
        Assert.assertEquals((long)5L, (long)edges.size());
        for (Edge edge : edges) {
            Assert.assertEquals((long)1L, (long)(((LongWritable)edge.getTargetVertexId()).get() % 2L));
        }
    }
}

