/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.HashMultimapEdges;
import org.apache.giraph.edge.MultiRandomAccessOutEdges;
import org.apache.giraph.graph.TestVertexAndEdges;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMultiRandomAccessEdges {
    private Collection<Class<? extends MultiRandomAccessOutEdges>> edgesClasses = Lists.newArrayList();

    @Before
    public void setUp() {
        this.edgesClasses.add(HashMultimapEdges.class);
    }

    @Test
    public void testParallelEdges() {
        for (Class<? extends MultiRandomAccessOutEdges> edgesClass : this.edgesClasses) {
            this.testParallelEdgesClass(edgesClass);
        }
    }

    private void testParallelEdgesClass(Class<? extends MultiRandomAccessOutEdges> edgesClass) {
        MultiRandomAccessOutEdges edges = (MultiRandomAccessOutEdges)TestVertexAndEdges.instantiateOutEdges(edgesClass);
        ArrayList initialEdges = Lists.newArrayList((Object[])new Edge[]{EdgeFactory.create((WritableComparable)new LongWritable(1L), (Writable)new DoubleWritable(1.0)), EdgeFactory.create((WritableComparable)new LongWritable(2L), (Writable)new DoubleWritable(2.0)), EdgeFactory.create((WritableComparable)new LongWritable(3L), (Writable)new DoubleWritable(3.0)), EdgeFactory.create((WritableComparable)new LongWritable(2L), (Writable)new DoubleWritable(20.0))});
        edges.initialize((Iterable)initialEdges);
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)edges.getAllEdgeValues((WritableComparable)new LongWritable(2L))));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)edges.getAllEdgeValues((WritableComparable)new LongWritable(1L))));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)edges.getAllEdgeValues((WritableComparable)new LongWritable(42L))));
    }
}

