/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.edge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.giraph.edge.ArrayListEdges;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.HashMultimapEdges;
import org.apache.giraph.edge.LongDoubleArrayEdges;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.TestVertexAndEdges;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMultiGraphEdges {
    private Collection<Class<? extends OutEdges>> edgesClasses = Lists.newArrayList();

    @Before
    public void setUp() {
        this.edgesClasses.add(ByteArrayEdges.class);
        this.edgesClasses.add(ArrayListEdges.class);
        this.edgesClasses.add(HashMultimapEdges.class);
        this.edgesClasses.add(LongDoubleArrayEdges.class);
    }

    @Test
    public void testParallelEdges() {
        for (Class<? extends OutEdges> edgesClass : this.edgesClasses) {
            this.testParallelEdgesClass(edgesClass);
        }
    }

    private void testParallelEdgesClass(Class<? extends OutEdges> edgesClass) {
        OutEdges edges = TestVertexAndEdges.instantiateOutEdges(edgesClass);
        ArrayList initialEdges = Lists.newArrayList((Object[])new Edge[]{EdgeFactory.create((WritableComparable)new LongWritable(1L), (Writable)new DoubleWritable(1.0)), EdgeFactory.create((WritableComparable)new LongWritable(2L), (Writable)new DoubleWritable(2.0)), EdgeFactory.create((WritableComparable)new LongWritable(3L), (Writable)new DoubleWritable(3.0)), EdgeFactory.create((WritableComparable)new LongWritable(2L), (Writable)new DoubleWritable(20.0))});
        edges.initialize((Iterable)initialEdges);
        Assert.assertEquals((long)4L, (long)edges.size());
        edges.add(EdgeFactory.create((WritableComparable)new LongWritable(3L), (Writable)new DoubleWritable(30.0)));
        Assert.assertEquals((long)5L, (long)edges.size());
        edges.remove((WritableComparable)new LongWritable(2L));
        Assert.assertEquals((long)3L, (long)edges.size());
    }
}

