/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.time.Times;
import org.apache.giraph.utils.LongNoOpComputation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestObjectCreation {
    @Rule
    public TestName name = new TestName();
    private static final Time TIME = SystemTime.get();
    private static final long COUNT = 200000L;
    private long startNanos = -1L;
    private long totalNanos = -1L;
    private long total = 0L;
    private long expected = 19999900000L;
    private ImmutableClassesGiraphConfiguration<LongWritable, LongWritable, LongWritable> configuration;

    @Before
    public void setUp() {
        GiraphConfiguration conf = new GiraphConfiguration();
        GiraphConstants.VERTEX_ID_CLASS.set((Configuration)conf, IntWritable.class);
        GiraphConstants.VERTEX_VALUE_CLASS.set((Configuration)conf, LongWritable.class);
        GiraphConstants.EDGE_VALUE_CLASS.set((Configuration)conf, DoubleWritable.class);
        GiraphConstants.INCOMING_MESSAGE_VALUE_CLASS.set((Configuration)conf, LongWritable.class);
        GiraphConstants.OUTGOING_MESSAGE_VALUE_CLASS.set((Configuration)conf, LongWritable.class);
        conf.setComputationClass(LongNoOpComputation.class);
        this.configuration = new ImmutableClassesGiraphConfiguration((Configuration)conf);
        this.total = 0L;
        System.gc();
    }

    @After
    public void cleanUp() {
        this.totalNanos = Times.getNanosSince((Time)TIME, (long)this.startNanos);
        System.out.println(this.name.getMethodName() + ": took " + this.totalNanos + " ns for " + 200000L + " elements " + (float)this.totalNanos * 1.0f / 200000.0f + " ns / element");
        Assert.assertEquals((long)this.expected, (long)this.total);
        System.gc();
    }

    @Test
    public void testCreateClass() {
        this.startNanos = TIME.getNanoseconds();
        int i = 0;
        while ((long)i < 200000L) {
            LongWritable value = (LongWritable)this.configuration.createVertexValue();
            value.set((long)i);
            this.total += value.get();
            ++i;
        }
    }

    @Test
    public void testNativeCreateClass() {
        this.startNanos = TIME.getNanoseconds();
        int i = 0;
        while ((long)i < 200000L) {
            LongWritable value = new LongWritable();
            value.set((long)i);
            this.total += value.get();
            ++i;
        }
    }

    private Class<?> getLongWritableClass() {
        return LongWritable.class;
    }

    @Test
    public void testNewInstance() throws IllegalAccessException, InstantiationException {
        this.startNanos = TIME.getNanoseconds();
        int i = 0;
        while ((long)i < 200000L) {
            LongWritable value = (LongWritable)this.getLongWritableClass().newInstance();
            value.set((long)i);
            this.total += value.get();
            ++i;
        }
    }

    private synchronized Class<?> getSyncLongWritableClass() {
        return LongWritable.class;
    }

    @Test
    public void testSyncNewInstance() throws IllegalAccessException, InstantiationException {
        this.startNanos = TIME.getNanoseconds();
        int i = 0;
        while ((long)i < 200000L) {
            LongWritable value = (LongWritable)this.getSyncLongWritableClass().newInstance();
            value.set((long)i);
            this.total += value.get();
            ++i;
        }
    }

    @Test
    public void testReflectionUtilsNewInstance() throws IllegalAccessException, InstantiationException {
        ReflectionUtils.newInstance(LongWritable.class, null);
        this.startNanos = TIME.getNanoseconds();
        int i = 0;
        while ((long)i < 200000L) {
            LongWritable value = (LongWritable)ReflectionUtils.newInstance(this.getLongWritableClass(), null);
            value.set((long)i);
            this.total += value.get();
            ++i;
        }
    }

    @Test
    public void testConstructorNewInstance() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Constructor constructor = LongWritable.class.getDeclaredConstructor(new Class[0]);
        this.startNanos = TIME.getNanoseconds();
        int i = 0;
        while ((long)i < 200000L) {
            LongWritable value = (LongWritable)constructor.newInstance(new Object[0]);
            value.set((long)i);
            this.total += value.get();
            ++i;
        }
    }

    private ImmutableClassesGiraphConfiguration<LongWritable, LongWritable, LongWritable> getConfiguration() {
        return this.configuration;
    }

    @Test
    public void testImmutableClassesGiraphConfigurationNewInstance() {
        this.startNanos = TIME.getNanoseconds();
        int i = 0;
        while ((long)i < 200000L) {
            LongWritable value = (LongWritable)this.getConfiguration().createVertexValue();
            value.set((long)i);
            this.total += value.get();
            ++i;
        }
    }
}

