/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import org.apache.giraph.conf.ClassConfOption;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;

public class TestGiraphConfiguration {
    @Test
    public void testSetClasses() {
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setClasses("foo", If.class, new Class[]{A.class, B.class});
        Class[] klasses = conf.getClasses("foo", new Class[0]);
        Assert.assertEquals((long)2L, (long)klasses.length);
        Assert.assertEquals(A.class, (Object)klasses[0]);
        Assert.assertEquals(B.class, (Object)klasses[1]);
        try {
            conf.setClasses("foo", A.class, new Class[]{B.class});
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((long)2L, (long)conf.getClasses("foo", new Class[0]).length);
        }
        Class[] klasses2 = ClassConfOption.getClassesOfType((Configuration)conf, (String)"foo", If.class, (Class[])new Class[0]);
        Assert.assertEquals((long)2L, (long)klasses2.length);
        Assert.assertEquals(A.class, (Object)klasses2[0]);
        Assert.assertEquals(B.class, (Object)klasses2[1]);
    }

    @Test
    public void testAddToClasses() {
        GiraphConfiguration conf = new GiraphConfiguration();
        conf.setClasses("foo", If.class, new Class[]{A.class, B.class});
        ClassConfOption.addToClasses((Configuration)conf, (String)"foo", C.class, If.class);
        Class[] klasses = conf.getClasses("foo", new Class[0]);
        Assert.assertEquals((long)3L, (long)klasses.length);
        Assert.assertEquals(A.class, (Object)klasses[0]);
        Assert.assertEquals(B.class, (Object)klasses[1]);
        Assert.assertEquals(C.class, (Object)klasses[2]);
        ClassConfOption.addToClasses((Configuration)conf, (String)"bar", B.class, If.class);
        klasses = conf.getClasses("bar", new Class[0]);
        Assert.assertEquals((long)1L, (long)klasses.length);
        Assert.assertEquals(B.class, (Object)klasses[0]);
    }

    public class C
    implements If {
    }

    public class B
    implements If {
    }

    public class A
    implements If {
    }

    public static interface If {
    }
}

