/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages.queue;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.queue.AsyncMessageStoreWrapper;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.TestMessageValueFactory;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Assert;
import org.junit.Test;

public class AsyncMessageStoreWrapperTest {
    @Test
    public void testAsyncQueue() throws IOException {
        TestMessageStore store = new TestMessageStore();
        AsyncMessageStoreWrapper queue = new AsyncMessageStoreWrapper((MessageStore)store, Arrays.asList(0, 1, 2, 3, 4), 2);
        for (int i = 0; i < 1000; ++i) {
            queue.addPartitionMessages(i % 5, (VertexIdMessages)new ByteArrayVertexIdMessages((MessageValueFactory)new TestMessageValueFactory(IntWritable.class)));
        }
        queue.waitToComplete();
        Assert.assertArrayEquals((int[])new int[]{200, 200, 200, 200, 200}, (int[])store.counters);
        queue.clearAll();
    }

    static class TestMessageStore
    implements MessageStore<LongWritable, IntWritable> {
        private int[] counters = new int[5];

        TestMessageStore() {
        }

        public void addPartitionMessages(int partition, VertexIdMessages messages) throws IOException {
            Assert.assertNotNull((Object)messages);
            int n = partition;
            this.counters[n] = this.counters[n] + 1;
        }

        public boolean isPointerListEncoding() {
            return false;
        }

        public Iterable<IntWritable> getVertexMessages(LongWritable vertexId) throws IOException {
            return null;
        }

        public void clearVertexMessages(LongWritable vertexId) throws IOException {
        }

        public void clearAll() throws IOException {
        }

        public boolean hasMessagesForVertex(LongWritable vertexId) {
            return false;
        }

        public void finalizeStore() {
        }

        public Iterable<LongWritable> getPartitionDestinationVertices(int partitionId) {
            return null;
        }

        public void clearPartition(int partitionId) throws IOException {
        }

        public void writePartition(DataOutput out, int partitionId) throws IOException {
        }

        public void readFieldsForPartition(DataInput in, int partitionId) throws IOException {
        }
    }
}

