/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.combiner.DoubleSumMessageCombiner;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.primitives.LongDoubleMessageStore;
import org.apache.giraph.comm.messages.primitives.long_id.LongByteArrayMessageStore;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.TestMessageValueFactory;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestLongDoublePrimitiveMessageStores {
    private static final int NUM_PARTITIONS = 2;
    private static CentralizedServiceWorker<LongWritable, Writable, Writable> service;

    @Before
    public void prepare() throws IOException {
        service = (CentralizedServiceWorker)Mockito.mock(CentralizedServiceWorker.class);
        Mockito.when((Object)service.getPartitionId((WritableComparable)Mockito.any(LongWritable.class))).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) {
                LongWritable vertexId = (LongWritable)invocation.getArguments()[0];
                return (int)(vertexId.get() % 2L);
            }
        });
        PartitionStore partitionStore = (PartitionStore)Mockito.mock(PartitionStore.class);
        Mockito.when((Object)service.getPartitionStore()).thenReturn((Object)partitionStore);
        Mockito.when((Object)partitionStore.getPartitionIds()).thenReturn((Object)Lists.newArrayList((Object[])new Integer[]{0, 1}));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.getVertexCount()).thenReturn((Object)1L);
        Mockito.when((Object)partitionStore.getOrCreatePartition(Integer.valueOf(0))).thenReturn((Object)partition);
        Mockito.when((Object)partitionStore.getOrCreatePartition(Integer.valueOf(1))).thenReturn((Object)partition);
    }

    private static ImmutableClassesGiraphConfiguration<LongWritable, Writable, Writable> createLongDoubleConf() {
        GiraphConfiguration initConf = new GiraphConfiguration();
        initConf.setComputationClass(LongDoubleNoOpComputation.class);
        return new ImmutableClassesGiraphConfiguration((Configuration)initConf);
    }

    private static ByteArrayVertexIdMessages<LongWritable, DoubleWritable> createLongDoubleMessages() {
        ByteArrayVertexIdMessages messages = new ByteArrayVertexIdMessages((MessageValueFactory)new TestMessageValueFactory(DoubleWritable.class));
        messages.setConf(TestLongDoublePrimitiveMessageStores.createLongDoubleConf());
        messages.initialize();
        return messages;
    }

    private static void insertLongDoubleMessages(MessageStore<LongWritable, DoubleWritable> messageStore) throws IOException {
        ByteArrayVertexIdMessages<LongWritable, DoubleWritable> messages = TestLongDoublePrimitiveMessageStores.createLongDoubleMessages();
        messages.add((WritableComparable)new LongWritable(0L), (Object)new DoubleWritable(1.0));
        messages.add((WritableComparable)new LongWritable(2L), (Object)new DoubleWritable(3.0));
        messages.add((WritableComparable)new LongWritable(0L), (Object)new DoubleWritable(4.0));
        messageStore.addPartitionMessages(0, messages);
        messages = TestLongDoublePrimitiveMessageStores.createLongDoubleMessages();
        messages.add((WritableComparable)new LongWritable(1L), (Object)new DoubleWritable(1.0));
        messages.add((WritableComparable)new LongWritable(1L), (Object)new DoubleWritable(3.0));
        messages.add((WritableComparable)new LongWritable(1L), (Object)new DoubleWritable(4.0));
        messageStore.addPartitionMessages(1, messages);
        messages = TestLongDoublePrimitiveMessageStores.createLongDoubleMessages();
        messages.add((WritableComparable)new LongWritable(0L), (Object)new DoubleWritable(5.0));
        messageStore.addPartitionMessages(0, messages);
    }

    @Test
    public void testLongDoubleMessageStore() throws IOException {
        LongDoubleMessageStore messageStore = new LongDoubleMessageStore(service, (MessageCombiner)new DoubleSumMessageCombiner());
        TestLongDoublePrimitiveMessageStores.insertLongDoubleMessages((MessageStore<LongWritable, DoubleWritable>)messageStore);
        Iterable m0 = messageStore.getVertexMessages(new LongWritable(0L));
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)m0));
        Assert.assertEquals((Object)10.0, (Object)((DoubleWritable)m0.iterator().next()).get());
        Iterable m1 = messageStore.getVertexMessages(new LongWritable(1L));
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)m1));
        Assert.assertEquals((Object)8.0, (Object)((DoubleWritable)m1.iterator().next()).get());
        Iterable m2 = messageStore.getVertexMessages(new LongWritable(2L));
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)m2));
        Assert.assertEquals((Object)3.0, (Object)((DoubleWritable)m2.iterator().next()).get());
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)messageStore.getVertexMessages(new LongWritable(3L))));
    }

    @Test
    public void testLongByteArrayMessageStore() throws IOException {
        LongByteArrayMessageStore messageStore = new LongByteArrayMessageStore((MessageValueFactory)new TestMessageValueFactory(DoubleWritable.class), service, TestLongDoublePrimitiveMessageStores.createLongDoubleConf());
        TestLongDoublePrimitiveMessageStores.insertLongDoubleMessages((MessageStore<LongWritable, DoubleWritable>)messageStore);
        Iterable m0 = messageStore.getVertexMessages(new LongWritable(0L));
        Assert.assertEquals((int)3, (int)Iterables.size((Iterable)m0));
        Iterator i0 = m0.iterator();
        Assert.assertEquals((Object)1.0, (Object)((DoubleWritable)i0.next()).get());
        Assert.assertEquals((Object)4.0, (Object)((DoubleWritable)i0.next()).get());
        Assert.assertEquals((Object)5.0, (Object)((DoubleWritable)i0.next()).get());
        Iterable m1 = messageStore.getVertexMessages(new LongWritable(1L));
        Assert.assertEquals((int)3, (int)Iterables.size((Iterable)m1));
        Iterator i1 = m1.iterator();
        Assert.assertEquals((Object)1.0, (Object)((DoubleWritable)i1.next()).get());
        Assert.assertEquals((Object)3.0, (Object)((DoubleWritable)i1.next()).get());
        Assert.assertEquals((Object)4.0, (Object)((DoubleWritable)i1.next()).get());
        Iterable m2 = messageStore.getVertexMessages(new LongWritable(2L));
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)m2));
        Assert.assertEquals((Object)3.0, (Object)((DoubleWritable)m2.iterator().next()).get());
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)messageStore.getVertexMessages(new LongWritable(3L))));
    }

    private static class LongDoubleNoOpComputation
    extends BasicComputation<LongWritable, NullWritable, NullWritable, DoubleWritable> {
        private LongDoubleNoOpComputation() {
        }

        public void compute(Vertex<LongWritable, NullWritable, NullWritable> vertex, Iterable<DoubleWritable> messages) throws IOException {
        }
    }
}

