/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.messages;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.combiner.FloatSumMessageCombiner;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.primitives.IntByteArrayMessageStore;
import org.apache.giraph.comm.messages.primitives.IntFloatMessageStore;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.TestMessageValueFactory;
import org.apache.giraph.graph.BasicComputation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestIntFloatPrimitiveMessageStores {
    private static final int NUM_PARTITIONS = 2;
    private static CentralizedServiceWorker<IntWritable, Writable, Writable> service;

    @Before
    public void prepare() throws IOException {
        service = (CentralizedServiceWorker)Mockito.mock(CentralizedServiceWorker.class);
        Mockito.when((Object)service.getPartitionId((WritableComparable)Mockito.any(IntWritable.class))).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) {
                IntWritable vertexId = (IntWritable)invocation.getArguments()[0];
                return vertexId.get() % 2;
            }
        });
        PartitionStore partitionStore = (PartitionStore)Mockito.mock(PartitionStore.class);
        Mockito.when((Object)service.getPartitionStore()).thenReturn((Object)partitionStore);
        Mockito.when((Object)partitionStore.getPartitionIds()).thenReturn((Object)Lists.newArrayList((Object[])new Integer[]{0, 1}));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.getVertexCount()).thenReturn((Object)1L);
        Mockito.when((Object)partitionStore.getOrCreatePartition(Integer.valueOf(0))).thenReturn((Object)partition);
        Mockito.when((Object)partitionStore.getOrCreatePartition(Integer.valueOf(1))).thenReturn((Object)partition);
    }

    private static ImmutableClassesGiraphConfiguration<IntWritable, Writable, Writable> createIntFloatConf() {
        GiraphConfiguration initConf = new GiraphConfiguration();
        initConf.setComputationClass(IntFloatNoOpComputation.class);
        return new ImmutableClassesGiraphConfiguration((Configuration)initConf);
    }

    private static ByteArrayVertexIdMessages<IntWritable, FloatWritable> createIntFloatMessages() {
        ByteArrayVertexIdMessages messages = new ByteArrayVertexIdMessages((MessageValueFactory)new TestMessageValueFactory(FloatWritable.class));
        messages.setConf(TestIntFloatPrimitiveMessageStores.createIntFloatConf());
        messages.initialize();
        return messages;
    }

    private static void insertIntFloatMessages(MessageStore<IntWritable, FloatWritable> messageStore) throws IOException {
        ByteArrayVertexIdMessages<IntWritable, FloatWritable> messages = TestIntFloatPrimitiveMessageStores.createIntFloatMessages();
        messages.add((WritableComparable)new IntWritable(0), (Object)new FloatWritable(1.0f));
        messages.add((WritableComparable)new IntWritable(2), (Object)new FloatWritable(3.0f));
        messages.add((WritableComparable)new IntWritable(0), (Object)new FloatWritable(4.0f));
        messageStore.addPartitionMessages(0, messages);
        messages = TestIntFloatPrimitiveMessageStores.createIntFloatMessages();
        messages.add((WritableComparable)new IntWritable(1), (Object)new FloatWritable(1.0f));
        messages.add((WritableComparable)new IntWritable(1), (Object)new FloatWritable(3.0f));
        messages.add((WritableComparable)new IntWritable(1), (Object)new FloatWritable(4.0f));
        messageStore.addPartitionMessages(1, messages);
        messages = TestIntFloatPrimitiveMessageStores.createIntFloatMessages();
        messages.add((WritableComparable)new IntWritable(0), (Object)new FloatWritable(5.0f));
        messageStore.addPartitionMessages(0, messages);
    }

    @Test
    public void testIntFloatMessageStore() throws IOException {
        IntFloatMessageStore messageStore = new IntFloatMessageStore(service, (MessageCombiner)new FloatSumMessageCombiner());
        TestIntFloatPrimitiveMessageStores.insertIntFloatMessages((MessageStore<IntWritable, FloatWritable>)messageStore);
        Iterable m0 = messageStore.getVertexMessages(new IntWritable(0));
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)m0));
        Assert.assertEquals((Object)Float.valueOf(10.0f), (Object)Float.valueOf(((FloatWritable)m0.iterator().next()).get()));
        Iterable m1 = messageStore.getVertexMessages(new IntWritable(1));
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)m1));
        Assert.assertEquals((Object)Float.valueOf(8.0f), (Object)Float.valueOf(((FloatWritable)m1.iterator().next()).get()));
        Iterable m2 = messageStore.getVertexMessages(new IntWritable(2));
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)m2));
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(((FloatWritable)m2.iterator().next()).get()));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)messageStore.getVertexMessages(new IntWritable(3))));
    }

    @Test
    public void testIntByteArrayMessageStore() throws IOException {
        IntByteArrayMessageStore messageStore = new IntByteArrayMessageStore((MessageValueFactory)new TestMessageValueFactory(FloatWritable.class), service, TestIntFloatPrimitiveMessageStores.createIntFloatConf());
        TestIntFloatPrimitiveMessageStores.insertIntFloatMessages((MessageStore<IntWritable, FloatWritable>)messageStore);
        Iterable m0 = messageStore.getVertexMessages(new IntWritable(0));
        Assert.assertEquals((int)3, (int)Iterables.size((Iterable)m0));
        Iterator i0 = m0.iterator();
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(((FloatWritable)i0.next()).get()));
        Assert.assertEquals((Object)Float.valueOf(4.0f), (Object)Float.valueOf(((FloatWritable)i0.next()).get()));
        Assert.assertEquals((Object)Float.valueOf(5.0f), (Object)Float.valueOf(((FloatWritable)i0.next()).get()));
        Iterable m1 = messageStore.getVertexMessages(new IntWritable(1));
        Assert.assertEquals((int)3, (int)Iterables.size((Iterable)m1));
        Iterator i1 = m1.iterator();
        Assert.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(((FloatWritable)i1.next()).get()));
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(((FloatWritable)i1.next()).get()));
        Assert.assertEquals((Object)Float.valueOf(4.0f), (Object)Float.valueOf(((FloatWritable)i1.next()).get()));
        Iterable m2 = messageStore.getVertexMessages(new IntWritable(2));
        Assert.assertEquals((int)1, (int)Iterables.size((Iterable)m2));
        Assert.assertEquals((Object)Float.valueOf(3.0f), (Object)Float.valueOf(((FloatWritable)m2.iterator().next()).get()));
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)messageStore.getVertexMessages(new IntWritable(3))));
    }

    private static class IntFloatNoOpComputation
    extends BasicComputation<IntWritable, NullWritable, NullWritable, FloatWritable> {
        private IntFloatNoOpComputation() {
        }

        public void compute(Vertex<IntWritable, NullWritable, NullWritable> vertex, Iterable<FloatWritable> messages) throws IOException {
        }
    }
}

