/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.messages.ByteArrayMessagesPerVertexStore;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.messages.out_of_core.DiskBackedMessageStore;
import org.apache.giraph.comm.messages.out_of_core.PartitionDiskBackedMessageStore;
import org.apache.giraph.comm.messages.out_of_core.SequentialFileMessageStore;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.TestMessageValueFactory;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.giraph.utils.CollectionUtils;
import org.apache.giraph.utils.IntNoOpComputation;
import org.apache.giraph.utils.MockUtils;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMessageStores {
    private static File directory;
    private static ImmutableClassesGiraphConfiguration<IntWritable, IntWritable, IntWritable> config;
    private static TestData testData;
    private static CentralizedServiceWorker<IntWritable, IntWritable, IntWritable> service;
    private static final Random RANDOM;

    @Before
    public void prepare() throws IOException {
        directory = Files.createTempDir();
        Configuration.addDefaultResource((String)"giraph-site.xml");
        GiraphConfiguration initConfig = new GiraphConfiguration();
        initConfig.setComputationClass(IntNoOpComputation.class);
        GiraphConstants.MESSAGES_DIRECTORY.set((Configuration)initConfig, new File(directory, "giraph_messages").toString());
        config = new ImmutableClassesGiraphConfiguration((Configuration)initConfig);
        testData = new TestData();
        TestMessageStores.testData.maxId = 1000000;
        TestMessageStores.testData.maxMessage = 1000000;
        TestMessageStores.testData.maxNumberOfMessages = 100;
        TestMessageStores.testData.numVertices = 50;
        TestMessageStores.testData.numTimes = 10;
        TestMessageStores.testData.numOfPartitions = 5;
        TestMessageStores.testData.maxMessagesInMemory = 20;
        service = MockUtils.mockServiceGetVertexPartitionOwner(TestMessageStores.testData.numOfPartitions);
    }

    @After
    public void cleanUp() throws IOException {
        FileUtils.deleteDirectory((File)directory);
    }

    private SortedMap<IntWritable, Collection<IntWritable>> createRandomMessages(TestData testData) {
        TreeMap<IntWritable, Collection<IntWritable>> allMessages = new TreeMap<IntWritable, Collection<IntWritable>>();
        for (int v = 0; v < testData.numVertices; ++v) {
            int messageNum = (int)(RANDOM.nextFloat() * (float)testData.maxNumberOfMessages);
            ArrayList vertexMessages = Lists.newArrayList();
            for (int m = 0; m < messageNum; ++m) {
                vertexMessages.add(new IntWritable((int)(RANDOM.nextFloat() * (float)testData.maxMessage)));
            }
            IntWritable vertexId = new IntWritable((int)(RANDOM.nextFloat() * (float)testData.maxId));
            allMessages.put(vertexId, vertexMessages);
        }
        return allMessages;
    }

    private static void addMessages(MessageStore<IntWritable, IntWritable> messageStore, CentralizedServiceWorker<IntWritable, ?, ?> service, ImmutableClassesGiraphConfiguration<IntWritable, ?, ?> config, Map<IntWritable, Collection<IntWritable>> inputMap) throws IOException {
        for (Map.Entry<IntWritable, Collection<IntWritable>> entry : inputMap.entrySet()) {
            int partitionId = service.getVertexPartitionOwner((WritableComparable)entry.getKey()).getPartitionId();
            ByteArrayVertexIdMessages byteArrayVertexIdMessages = new ByteArrayVertexIdMessages((MessageValueFactory)new TestMessageValueFactory(IntWritable.class));
            byteArrayVertexIdMessages.setConf(config);
            byteArrayVertexIdMessages.initialize();
            for (IntWritable message : entry.getValue()) {
                byteArrayVertexIdMessages.add((WritableComparable)entry.getKey(), (Object)message);
            }
            messageStore.addPartitionMessages(partitionId, (VertexIdMessages)byteArrayVertexIdMessages);
        }
    }

    private void putNTimes(MessageStore<IntWritable, IntWritable> messageStore, Map<IntWritable, Collection<IntWritable>> messages, TestData testData) throws IOException {
        for (int n = 0; n < testData.numTimes; ++n) {
            SortedMap<IntWritable, Collection<IntWritable>> batch = this.createRandomMessages(testData);
            TestMessageStores.addMessages(messageStore, service, config, batch);
            for (Map.Entry<IntWritable, Collection<IntWritable>> entry : batch.entrySet()) {
                if (messages.containsKey(entry.getKey())) {
                    messages.get(entry.getKey()).addAll(entry.getValue());
                    continue;
                }
                messages.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private <I extends WritableComparable, M extends Writable> boolean equalMessages(MessageStore<I, M> messageStore, Map<I, Collection<M>> expectedMessages, TestData testData) throws IOException {
        for (int partitionId = 0; partitionId < testData.numOfPartitions; ++partitionId) {
            TreeSet vertexIds = Sets.newTreeSet();
            Iterables.addAll((Collection)vertexIds, (Iterable)messageStore.getPartitionDestinationVertices(partitionId));
            for (WritableComparable vertexId : vertexIds) {
                Iterable expected = expectedMessages.get(vertexId);
                if (expected == null) {
                    return false;
                }
                Iterable actual = messageStore.getVertexMessages(vertexId);
                if (CollectionUtils.isEqual((Iterable)expected, (Iterable)actual)) continue;
                System.err.println("equalMessages: For vertexId " + vertexId + " expected " + expected + ", but got " + actual);
                return false;
            }
        }
        return true;
    }

    private <S extends MessageStore<IntWritable, IntWritable>> S doCheckpoint(MessageStoreFactory<IntWritable, IntWritable, S> messageStoreFactory, S messageStore, TestData testData) throws IOException {
        File file = new File(directory, "messageStoreTest");
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        for (int partitionId = 0; partitionId < testData.numOfPartitions; ++partitionId) {
            messageStore.writePartition((DataOutput)out, partitionId);
        }
        out.close();
        messageStore = (MessageStore)messageStoreFactory.newStore((MessageValueFactory)new TestMessageValueFactory(IntWritable.class));
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        for (int partitionId = 0; partitionId < testData.numOfPartitions; ++partitionId) {
            messageStore.readFieldsForPartition((DataInput)in, partitionId);
        }
        in.close();
        file.delete();
        return messageStore;
    }

    private <S extends MessageStore<IntWritable, IntWritable>> void testMessageStore(MessageStoreFactory<IntWritable, IntWritable, S> messageStoreFactory, TestData testData) throws IOException {
        TreeMap<IntWritable, Collection<IntWritable>> messages = new TreeMap<IntWritable, Collection<IntWritable>>();
        MessageStore messageStore = (MessageStore)messageStoreFactory.newStore((MessageValueFactory)new TestMessageValueFactory(IntWritable.class));
        this.putNTimes((MessageStore<IntWritable, IntWritable>)messageStore, messages, testData);
        Assert.assertTrue((boolean)this.equalMessages(messageStore, messages, testData));
        messageStore.clearAll();
        messageStore = this.doCheckpoint(messageStoreFactory, messageStore, testData);
        Assert.assertTrue((boolean)this.equalMessages(messageStore, messages, testData));
        messageStore.clearAll();
    }

    @Test
    public void testByteArrayMessagesPerVertexStore() {
        try {
            this.testMessageStore(ByteArrayMessagesPerVertexStore.newFactory(service, config), testData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDiskBackedMessageStoreByPartition() {
        try {
            MessageStoreFactory fileStoreFactory = SequentialFileMessageStore.newFactory(config);
            MessageStoreFactory partitionStoreFactory = PartitionDiskBackedMessageStore.newFactory(config, (MessageStoreFactory)fileStoreFactory);
            this.testMessageStore(DiskBackedMessageStore.newFactory(service, (int)TestMessageStores.testData.maxMessagesInMemory, (MessageStoreFactory)partitionStoreFactory), testData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        RANDOM = new Random(101L);
    }

    private static class TestData {
        int numTimes;
        int numVertices;
        int maxNumberOfMessages;
        int maxId;
        int maxMessage;
        int numOfPartitions;
        int maxMessagesInMemory;

        private TestData() {
        }
    }
}

