/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import org.apache.giraph.comm.MockExceptionHandler;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.netty.NettyClient;
import org.apache.giraph.comm.netty.NettyServer;
import org.apache.giraph.comm.netty.handler.RequestServerHandler;
import org.apache.giraph.comm.netty.handler.SaslServerHandler;
import org.apache.giraph.comm.netty.handler.WorkerRequestServerHandler;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.TaskInfo;
import org.apache.giraph.utils.IntNoOpComputation;
import org.apache.giraph.utils.MockUtils;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SaslConnectionTest {
    private ImmutableClassesGiraphConfiguration conf;

    @Before
    public void setUp() {
        GiraphConfiguration tmpConfig = new GiraphConfiguration();
        tmpConfig.setComputationClass(IntNoOpComputation.class);
        GiraphConstants.AUTHENTICATE.set((Configuration)tmpConfig, true);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)tmpConfig);
    }

    @Test
    public void connectSingleClientServer() throws IOException {
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)this.conf);
        ServerData<IntWritable, IntWritable, IntWritable> serverData = MockUtils.createNewServerData(this.conf, context);
        SaslServerHandler.Factory mockedSaslServerFactory = (SaslServerHandler.Factory)Mockito.mock(SaslServerHandler.Factory.class);
        SaslServerHandler mockedSaslServerHandler = (SaslServerHandler)Mockito.mock(SaslServerHandler.class);
        Mockito.when((Object)mockedSaslServerFactory.newHandler((Configuration)this.conf)).thenReturn((Object)mockedSaslServerHandler);
        WorkerInfo workerInfo = new WorkerInfo();
        workerInfo.setTaskId(-1);
        NettyServer server = new NettyServer(this.conf, (RequestServerHandler.Factory)new WorkerRequestServerHandler.Factory(serverData), (TaskInfo)workerInfo, (Progressable)context, mockedSaslServerFactory, (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        server.start();
        workerInfo.setInetSocketAddress(server.getMyAddress());
        NettyClient client = new NettyClient(context, this.conf, (TaskInfo)new WorkerInfo(), (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        client.connectAllAddresses((Collection)Lists.newArrayList((Object[])new WorkerInfo[]{workerInfo}));
        client.stop();
        server.stop();
    }
}

