/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.giraph.comm.MockExceptionHandler;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.netty.NettyClient;
import org.apache.giraph.comm.netty.NettyServer;
import org.apache.giraph.comm.netty.handler.RequestServerHandler;
import org.apache.giraph.comm.netty.handler.WorkerRequestServerHandler;
import org.apache.giraph.comm.requests.SendPartitionMutationsRequest;
import org.apache.giraph.comm.requests.SendVertexRequest;
import org.apache.giraph.comm.requests.SendWorkerMessagesRequest;
import org.apache.giraph.comm.requests.SendWorkerOneMessageToManyRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.TestMessageValueFactory;
import org.apache.giraph.graph.TaskInfo;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexMutations;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.utils.ByteArrayOneMessageToManyIds;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.IntNoOpComputation;
import org.apache.giraph.utils.MockUtils;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RequestTest {
    private ImmutableClassesGiraphConfiguration conf;
    private ServerData<IntWritable, IntWritable, IntWritable> serverData;
    private NettyServer server;
    private NettyClient client;
    private WorkerInfo workerInfo;

    @Before
    public void setUp() throws IOException {
        GiraphConfiguration tmpConf = new GiraphConfiguration();
        GiraphConstants.COMPUTATION_CLASS.set((Configuration)tmpConf, IntNoOpComputation.class);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)tmpConf);
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)this.conf);
        this.serverData = MockUtils.createNewServerData(this.conf, context);
        this.serverData.prepareSuperstep();
        this.workerInfo = new WorkerInfo();
        this.server = new NettyServer(this.conf, (RequestServerHandler.Factory)new WorkerRequestServerHandler.Factory(this.serverData), (TaskInfo)this.workerInfo, (Progressable)context, (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        this.server.start();
        this.workerInfo.setInetSocketAddress(this.server.getMyAddress());
        this.client = new NettyClient(context, this.conf, (TaskInfo)new WorkerInfo(), (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        this.client.connectAllAddresses((Collection)Lists.newArrayList((Object[])new WorkerInfo[]{this.workerInfo}));
    }

    @Test
    public void sendVertexPartition() throws IOException {
        int partitionId = 13;
        Partition partition = this.conf.createPartition(partitionId, null);
        for (int i = 0; i < 10; ++i) {
            Vertex vertex = this.conf.createVertex();
            vertex.initialize((WritableComparable)new IntWritable(i), (Writable)new IntWritable(i));
            partition.putVertex(vertex);
        }
        SendVertexRequest request = new SendVertexRequest(partition);
        this.client.sendWritableRequest(Integer.valueOf(this.workerInfo.getTaskId()), (WritableRequest)request);
        this.client.waitAllRequests();
        this.client.stop();
        this.server.stop();
        PartitionStore partitionStore = this.serverData.getPartitionStore();
        Assert.assertTrue((boolean)partitionStore.hasPartition(Integer.valueOf(partitionId)));
        int total = 0;
        Partition partition2 = partitionStore.getOrCreatePartition(Integer.valueOf(partitionId));
        for (Vertex vertex : partition2) {
            total += ((IntWritable)vertex.getId()).get();
        }
        partitionStore.putPartition(partition2);
        Assert.assertEquals((long)total, (long)45L);
        partitionStore.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendWorkerMessagesRequest() throws IOException {
        PairList dataToSend = new PairList();
        dataToSend.initialize();
        int partitionId = 0;
        ByteArrayVertexIdMessages vertexIdMessages = new ByteArrayVertexIdMessages((MessageValueFactory)new TestMessageValueFactory(IntWritable.class));
        vertexIdMessages.setConf(this.conf);
        vertexIdMessages.initialize();
        dataToSend.add((Object)partitionId, (Object)vertexIdMessages);
        for (int i = 1; i < 7; ++i) {
            IntWritable vertexId = new IntWritable(i);
            for (int j = 0; j < i; ++j) {
                vertexIdMessages.add((WritableComparable)vertexId, (Object)new IntWritable(j));
            }
        }
        SendWorkerMessagesRequest request = new SendWorkerMessagesRequest(dataToSend);
        request.setConf(this.conf);
        this.client.sendWritableRequest(Integer.valueOf(this.workerInfo.getTaskId()), (WritableRequest)request);
        this.client.waitAllRequests();
        this.client.stop();
        this.server.stop();
        Iterable vertices = this.serverData.getIncomingMessageStore().getPartitionDestinationVertices(0);
        int keySum = 0;
        int messageSum = 0;
        for (IntWritable vertexId : vertices) {
            Iterable messages;
            keySum += vertexId.get();
            Iterable iterable = messages = this.serverData.getIncomingMessageStore().getVertexMessages((WritableComparable)vertexId);
            synchronized (iterable) {
                for (IntWritable message : messages) {
                    messageSum += message.get();
                }
            }
        }
        Assert.assertEquals((long)21L, (long)keySum);
        Assert.assertEquals((long)35L, (long)messageSum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendWorkerIndividualMessagesRequest() throws IOException {
        ByteArrayOneMessageToManyIds dataToSend = new ByteArrayOneMessageToManyIds((MessageValueFactory)new TestMessageValueFactory(IntWritable.class));
        dataToSend.setConf(this.conf);
        dataToSend.initialize();
        ExtendedDataOutput output = this.conf.createExtendedDataOutput();
        for (int i = 1; i <= 7; ++i) {
            IntWritable vertexId = new IntWritable(i);
            vertexId.write((DataOutput)output);
        }
        dataToSend.add(output.getByteArray(), output.getPos(), 7, (Writable)new IntWritable(1));
        SendWorkerOneMessageToManyRequest request = new SendWorkerOneMessageToManyRequest(dataToSend, this.conf);
        this.client.sendWritableRequest(Integer.valueOf(this.workerInfo.getTaskId()), (WritableRequest)request);
        this.client.waitAllRequests();
        this.client.stop();
        this.server.stop();
        Iterable vertices = this.serverData.getIncomingMessageStore().getPartitionDestinationVertices(0);
        int keySum = 0;
        int messageSum = 0;
        for (IntWritable vertexId : vertices) {
            Iterable messages;
            keySum += vertexId.get();
            Iterable iterable = messages = this.serverData.getIncomingMessageStore().getVertexMessages((WritableComparable)vertexId);
            synchronized (iterable) {
                for (IntWritable message : messages) {
                    messageSum += message.get();
                }
            }
        }
        Assert.assertEquals((long)28L, (long)keySum);
        Assert.assertEquals((long)7L, (long)messageSum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sendPartitionMutationsRequest() throws IOException {
        int partitionId = 19;
        HashMap vertexIdMutations = Maps.newHashMap();
        for (int i = 0; i < 11; ++i) {
            int j;
            VertexMutations mutations = new VertexMutations();
            for (j = 0; j < 3; ++j) {
                Vertex vertex = this.conf.createVertex();
                vertex.initialize((WritableComparable)new IntWritable(i), (Writable)new IntWritable(j));
                mutations.addVertex(vertex);
            }
            for (j = 0; j < 2; ++j) {
                mutations.removeVertex();
            }
            for (j = 0; j < 5; ++j) {
                Edge edge = EdgeFactory.create((WritableComparable)new IntWritable(i), (Writable)new IntWritable(2 * j));
                mutations.addEdge(edge);
            }
            for (j = 0; j < 7; ++j) {
                mutations.removeEdge((WritableComparable)new IntWritable(j));
            }
            vertexIdMutations.put(new IntWritable(i), mutations);
        }
        SendPartitionMutationsRequest request = new SendPartitionMutationsRequest(partitionId, (Map)vertexIdMutations);
        GiraphMetrics.init((GiraphConfiguration)this.conf);
        this.client.sendWritableRequest(Integer.valueOf(this.workerInfo.getTaskId()), (WritableRequest)request);
        this.client.waitAllRequests();
        this.client.stop();
        this.server.stop();
        ConcurrentHashMap inVertexIdMutations = this.serverData.getVertexMutations();
        int keySum = 0;
        for (Map.Entry entry : inVertexIdMutations.entrySet()) {
            VertexMutations vertexMutations = (VertexMutations)entry.getValue();
            synchronized (vertexMutations) {
                keySum += ((IntWritable)entry.getKey()).get();
                int vertexValueSum = 0;
                for (Vertex vertex : ((VertexMutations)entry.getValue()).getAddedVertexList()) {
                    vertexValueSum += ((IntWritable)vertex.getValue()).get();
                }
                Assert.assertEquals((long)3L, (long)vertexValueSum);
                Assert.assertEquals((long)2L, (long)((VertexMutations)entry.getValue()).getRemovedVertexCount());
                int removeEdgeValueSum = 0;
                for (Edge edge : ((VertexMutations)entry.getValue()).getAddedEdgeList()) {
                    removeEdgeValueSum += ((IntWritable)edge.getValue()).get();
                }
                Assert.assertEquals((long)20L, (long)removeEdgeValueSum);
            }
        }
        Assert.assertEquals((long)55L, (long)keySum);
    }
}

