/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import org.apache.giraph.comm.MockExceptionHandler;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.netty.NettyClient;
import org.apache.giraph.comm.netty.NettyServer;
import org.apache.giraph.comm.netty.handler.RequestServerHandler;
import org.apache.giraph.comm.netty.handler.WorkerRequestServerHandler;
import org.apache.giraph.comm.requests.SendWorkerMessagesRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.TestMessageValueFactory;
import org.apache.giraph.graph.TaskInfo;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.giraph.utils.IntNoOpComputation;
import org.apache.giraph.utils.MockUtils;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RequestFailureTest {
    private ImmutableClassesGiraphConfiguration conf;
    private ServerData<IntWritable, IntWritable, IntWritable> serverData;
    private NettyServer server;
    private NettyClient client;
    private Mapper.Context context;

    @Before
    public void setUp() throws IOException {
        GiraphConfiguration tmpConf = new GiraphConfiguration();
        tmpConf.setComputationClass(IntNoOpComputation.class);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)tmpConf);
        this.context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)this.context.getConfiguration()).thenReturn((Object)this.conf);
    }

    private WritableRequest getRequest() {
        boolean partitionId = false;
        PairList dataToSend = new PairList();
        dataToSend.initialize();
        ByteArrayVertexIdMessages vertexIdMessages = new ByteArrayVertexIdMessages((MessageValueFactory)new TestMessageValueFactory(IntWritable.class));
        vertexIdMessages.setConf(this.conf);
        vertexIdMessages.initialize();
        dataToSend.add((Object)0, (Object)vertexIdMessages);
        for (int i = 1; i < 7; ++i) {
            IntWritable vertexId = new IntWritable(i);
            for (int j = 0; j < i; ++j) {
                vertexIdMessages.add((WritableComparable)vertexId, (Object)new IntWritable(j));
            }
        }
        SendWorkerMessagesRequest request = new SendWorkerMessagesRequest(dataToSend);
        request.setConf(this.conf);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResult(int numRequests) throws IOException {
        Iterable vertices = this.serverData.getIncomingMessageStore().getPartitionDestinationVertices(0);
        int keySum = 0;
        int messageSum = 0;
        for (IntWritable vertexId : vertices) {
            Iterable messages;
            keySum += vertexId.get();
            Iterable iterable = messages = this.serverData.getIncomingMessageStore().getVertexMessages((WritableComparable)vertexId);
            synchronized (iterable) {
                for (IntWritable message : messages) {
                    messageSum += message.get();
                }
            }
        }
        Assert.assertEquals((long)21L, (long)keySum);
        Assert.assertEquals((long)(35 * numRequests), (long)messageSum);
    }

    @Test
    public void send2Requests() throws IOException {
        this.checkSendingTwoRequests();
    }

    @Test
    public void alreadyProcessedRequest() throws IOException {
        GiraphConstants.NETTY_SIMULATE_FIRST_RESPONSE_FAILED.set((Configuration)this.conf, true);
        GiraphConstants.MAX_REQUEST_MILLISECONDS.set((Configuration)this.conf, 1000);
        GiraphConstants.WAITING_REQUEST_MSECS.set((Configuration)this.conf, 2000);
        this.checkSendingTwoRequests();
    }

    @Test
    public void resendRequest() throws IOException {
        GiraphConstants.NETTY_SIMULATE_FIRST_REQUEST_CLOSED.set((Configuration)this.conf, true);
        GiraphConstants.MAX_REQUEST_MILLISECONDS.set((Configuration)this.conf, 1000);
        GiraphConstants.WAITING_REQUEST_MSECS.set((Configuration)this.conf, 2000);
        this.checkSendingTwoRequests();
    }

    private void checkSendingTwoRequests() throws IOException {
        this.serverData = MockUtils.createNewServerData(this.conf, this.context);
        this.serverData.prepareSuperstep();
        WorkerInfo workerInfo = new WorkerInfo();
        this.server = new NettyServer(this.conf, (RequestServerHandler.Factory)new WorkerRequestServerHandler.Factory(this.serverData), (TaskInfo)workerInfo, (Progressable)this.context, (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        this.server.start();
        workerInfo.setInetSocketAddress(this.server.getMyAddress());
        this.client = new NettyClient(this.context, this.conf, (TaskInfo)new WorkerInfo(), (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        this.client.connectAllAddresses((Collection)Lists.newArrayList((Object[])new WorkerInfo[]{workerInfo}));
        WritableRequest request1 = this.getRequest();
        WritableRequest request2 = this.getRequest();
        this.client.sendWritableRequest(Integer.valueOf(workerInfo.getTaskId()), request1);
        this.client.sendWritableRequest(Integer.valueOf(workerInfo.getTaskId()), request2);
        this.client.waitAllRequests();
        this.client.stop();
        this.server.stop();
        this.checkResult(2);
    }
}

