/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import org.apache.giraph.utils.IncreasingBitSet;
import org.junit.Assert;
import org.junit.Test;

public class IncreasingBitSetTest {
    @Test
    public void add256kIntegers() {
        IncreasingBitSet IncreasingBitSet2 = new IncreasingBitSet();
        for (int i = 0; i < 262144; ++i) {
            Assert.assertFalse((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.add((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertTrue((IncreasingBitSet2.size() <= 65536 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)262144L, (long)IncreasingBitSet2.getLastBaseKey());
    }

    @Test
    public void add256kIntegersAlternate() {
        int i;
        IncreasingBitSet IncreasingBitSet2 = new IncreasingBitSet();
        for (i = 0; i < 262144; i += 2) {
            Assert.assertFalse((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.add((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertFalse((boolean)IncreasingBitSet2.has((long)(i + 1)));
            Assert.assertTrue((IncreasingBitSet2.size() <= 262144 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)131072L, (long)IncreasingBitSet2.cardinality());
        for (i = 1; i < 262144; i += 2) {
            Assert.assertFalse((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.add((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.has((long)(i - 1)));
            Assert.assertTrue((IncreasingBitSet2.size() <= 262144 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)262144L, (long)IncreasingBitSet2.cardinality());
    }

    @Test
    public void add256kIntegersOutOfOrder() {
        int i;
        IncreasingBitSet IncreasingBitSet2 = new IncreasingBitSet();
        for (i = 131072; i < 262144; ++i) {
            Assert.assertFalse((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.add((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertTrue((IncreasingBitSet2.size() <= 524288 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)131072L, (long)IncreasingBitSet2.cardinality());
        for (i = 0; i < 131072; ++i) {
            Assert.assertFalse((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.add((long)i));
            Assert.assertTrue((boolean)IncreasingBitSet2.has((long)i));
            Assert.assertTrue((IncreasingBitSet2.size() <= 524288 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)262144L, (long)IncreasingBitSet2.cardinality());
        Assert.assertEquals((long)262144L, (long)IncreasingBitSet2.getLastBaseKey());
    }
}

