/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.giraph.comm.MockExceptionHandler;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.netty.NettyClient;
import org.apache.giraph.comm.netty.NettyServer;
import org.apache.giraph.comm.netty.handler.RequestServerHandler;
import org.apache.giraph.comm.netty.handler.WorkerRequestServerHandler;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.TaskInfo;
import org.apache.giraph.utils.IntNoOpComputation;
import org.apache.giraph.utils.MockUtils;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ConnectionTest {
    private ImmutableClassesGiraphConfiguration conf;

    @Before
    public void setUp() {
        GiraphConfiguration tmpConfig = new GiraphConfiguration();
        tmpConfig.setComputationClass(IntNoOpComputation.class);
        this.conf = new ImmutableClassesGiraphConfiguration((Configuration)tmpConfig);
    }

    @Test
    public void connectSingleClientServer() throws IOException {
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)this.conf);
        ServerData<IntWritable, IntWritable, IntWritable> serverData = MockUtils.createNewServerData(this.conf, context);
        WorkerInfo workerInfo = new WorkerInfo();
        NettyServer server = new NettyServer(this.conf, (RequestServerHandler.Factory)new WorkerRequestServerHandler.Factory(serverData), (TaskInfo)workerInfo, (Progressable)context, (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        server.start();
        workerInfo.setInetSocketAddress(server.getMyAddress());
        NettyClient client = new NettyClient(context, this.conf, (TaskInfo)new WorkerInfo(), (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        client.connectAllAddresses((Collection)Lists.newArrayList((Object[])new WorkerInfo[]{workerInfo}));
        client.stop();
        server.stop();
    }

    @Test
    public void connectOneClientToThreeServers() throws IOException {
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)this.conf);
        ServerData<IntWritable, IntWritable, IntWritable> serverData = MockUtils.createNewServerData(this.conf, context);
        WorkerRequestServerHandler.Factory requestServerHandlerFactory = new WorkerRequestServerHandler.Factory(serverData);
        WorkerInfo workerInfo1 = new WorkerInfo();
        workerInfo1.setTaskId(1);
        NettyServer server1 = new NettyServer(this.conf, (RequestServerHandler.Factory)requestServerHandlerFactory, (TaskInfo)workerInfo1, (Progressable)context, (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        server1.start();
        workerInfo1.setInetSocketAddress(server1.getMyAddress());
        WorkerInfo workerInfo2 = new WorkerInfo();
        workerInfo1.setTaskId(2);
        NettyServer server2 = new NettyServer(this.conf, (RequestServerHandler.Factory)requestServerHandlerFactory, (TaskInfo)workerInfo2, (Progressable)context, (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        server2.start();
        workerInfo2.setInetSocketAddress(server2.getMyAddress());
        WorkerInfo workerInfo3 = new WorkerInfo();
        workerInfo1.setTaskId(3);
        NettyServer server3 = new NettyServer(this.conf, (RequestServerHandler.Factory)requestServerHandlerFactory, (TaskInfo)workerInfo3, (Progressable)context, (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        server3.start();
        workerInfo3.setInetSocketAddress(server3.getMyAddress());
        NettyClient client = new NettyClient(context, this.conf, (TaskInfo)new WorkerInfo(), (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        ArrayList addresses = Lists.newArrayList((Object[])new WorkerInfo[]{workerInfo1, workerInfo2, workerInfo3});
        client.connectAllAddresses((Collection)addresses);
        client.stop();
        server1.stop();
        server2.stop();
        server3.stop();
    }

    @Test
    public void connectThreeClientsToOneServer() throws IOException {
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)this.conf);
        ServerData<IntWritable, IntWritable, IntWritable> serverData = MockUtils.createNewServerData(this.conf, context);
        WorkerInfo workerInfo = new WorkerInfo();
        NettyServer server = new NettyServer(this.conf, (RequestServerHandler.Factory)new WorkerRequestServerHandler.Factory(serverData), (TaskInfo)workerInfo, (Progressable)context, (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        server.start();
        workerInfo.setInetSocketAddress(server.getMyAddress());
        ArrayList addresses = Lists.newArrayList((Object[])new WorkerInfo[]{workerInfo});
        NettyClient client1 = new NettyClient(context, this.conf, (TaskInfo)new WorkerInfo(), (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        client1.connectAllAddresses((Collection)addresses);
        NettyClient client2 = new NettyClient(context, this.conf, (TaskInfo)new WorkerInfo(), (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        client2.connectAllAddresses((Collection)addresses);
        NettyClient client3 = new NettyClient(context, this.conf, (TaskInfo)new WorkerInfo(), (Thread.UncaughtExceptionHandler)new MockExceptionHandler());
        client3.connectAllAddresses((Collection)addresses);
        client1.stop();
        client2.stop();
        client3.stop();
        server.stop();
    }
}

