/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import org.apache.giraph.aggregators.matrix.sparse.LongSparseVector;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestLongSparseMatrix {
    @Test
    public void testVectorAdd() {
        LongSparseVector vec1 = new LongSparseVector();
        Assert.assertEquals((long)0L, (long)vec1.get(0));
        vec1.set(0, 1L);
        vec1.set(10, 14L);
        Assert.assertEquals((long)1L, (long)vec1.get(0));
        Assert.assertEquals((long)0L, (long)vec1.get(5));
        Assert.assertEquals((long)14L, (long)vec1.get(10));
        LongSparseVector vec2 = new LongSparseVector();
        vec2.set(0, 5L);
        vec2.set(5, 17L);
        vec1.add(vec2);
        Assert.assertEquals((long)6L, (long)vec1.get(0));
        Assert.assertEquals((long)17L, (long)vec1.get(5));
        Assert.assertEquals((long)14L, (long)vec1.get(10));
        Assert.assertEquals((long)0L, (long)vec1.get(15));
    }

    @Test
    public void testVectorSerialize() throws Exception {
        int size = 100;
        LongSparseVector from = new LongSparseVector(size);
        from.set(0, 10L);
        from.set(10, 5L);
        from.set(12, 1L);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from});
        LongSparseVector to = new LongSparseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to});
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)from.get(i), (long)to.get(i));
        }
    }
}

