/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import org.apache.giraph.aggregators.matrix.sparse.IntSparseVector;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestIntSparseMatrix {
    @Test
    public void testVectorAdd() {
        IntSparseVector vec1 = new IntSparseVector();
        Assert.assertEquals((long)0L, (long)vec1.get(0));
        vec1.set(0, 1);
        vec1.set(10, 14);
        Assert.assertEquals((long)1L, (long)vec1.get(0));
        Assert.assertEquals((long)0L, (long)vec1.get(5));
        Assert.assertEquals((long)14L, (long)vec1.get(10));
        IntSparseVector vec2 = new IntSparseVector();
        vec2.set(0, 5);
        vec2.set(5, 17);
        vec1.add(vec2);
        Assert.assertEquals((long)6L, (long)vec1.get(0));
        Assert.assertEquals((long)17L, (long)vec1.get(5));
        Assert.assertEquals((long)14L, (long)vec1.get(10));
        Assert.assertEquals((long)0L, (long)vec1.get(15));
    }

    @Test
    public void testVectorSerialize() throws Exception {
        int size = 100;
        IntSparseVector from = new IntSparseVector(size);
        from.set(0, 10);
        from.set(10, 5);
        from.set(12, 1);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from});
        IntSparseVector to = new IntSparseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to});
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)from.get(i), (long)to.get(i));
        }
    }
}

