/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import org.apache.giraph.aggregators.matrix.sparse.FloatSparseVector;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestFloatSparseMatrix {
    private static float E = 1.0E-4f;

    @Test
    public void testVectorAdd() {
        FloatSparseVector vec1 = new FloatSparseVector();
        Assert.assertEquals((double)0.0, (double)vec1.get(0), (double)E);
        vec1.set(0, 0.1f);
        vec1.set(10, 1.4f);
        Assert.assertEquals((double)0.1, (double)vec1.get(0), (double)E);
        Assert.assertEquals((double)0.0, (double)vec1.get(5), (double)E);
        Assert.assertEquals((double)1.4, (double)vec1.get(10), (double)E);
        FloatSparseVector vec2 = new FloatSparseVector();
        vec2.set(0, 0.5f);
        vec2.set(5, 1.7f);
        vec1.add(vec2);
        Assert.assertEquals((double)0.6, (double)vec1.get(0), (double)E);
        Assert.assertEquals((double)1.7, (double)vec1.get(5), (double)E);
        Assert.assertEquals((double)1.4, (double)vec1.get(10), (double)E);
        Assert.assertEquals((double)0.0, (double)vec1.get(15), (double)E);
    }

    @Test
    public void testVectorSerialize() throws Exception {
        int size = 100;
        FloatSparseVector from = new FloatSparseVector(size);
        from.set(0, 10.0f);
        from.set(10, 5.0f);
        from.set(12, 1.0f);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from});
        FloatSparseVector to = new FloatSparseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to});
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((float)from.get(i), (float)to.get(i), (float)E);
        }
    }
}

