/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.sparse;

import org.apache.giraph.aggregators.matrix.sparse.DoubleSparseVector;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestDoubleSparseMatrix {
    private static double E = 1.0E-4f;

    @Test
    public void testVectorAdd() {
        DoubleSparseVector vec1 = new DoubleSparseVector();
        Assert.assertEquals((double)0.0, (double)vec1.get(0), (double)E);
        vec1.set(0, 0.1);
        vec1.set(10, 1.4);
        Assert.assertEquals((double)0.1, (double)vec1.get(0), (double)E);
        Assert.assertEquals((double)0.0, (double)vec1.get(5), (double)E);
        Assert.assertEquals((double)1.4, (double)vec1.get(10), (double)E);
        DoubleSparseVector vec2 = new DoubleSparseVector();
        vec2.set(0, 0.5);
        vec2.set(5, 1.7);
        vec1.add(vec2);
        Assert.assertEquals((double)0.6, (double)vec1.get(0), (double)E);
        Assert.assertEquals((double)1.7, (double)vec1.get(5), (double)E);
        Assert.assertEquals((double)1.4, (double)vec1.get(10), (double)E);
        Assert.assertEquals((double)0.0, (double)vec1.get(15), (double)E);
    }

    @Test
    public void testVectorSerialize() throws Exception {
        int size = 100;
        DoubleSparseVector from = new DoubleSparseVector(size);
        from.set(0, 10.0);
        from.set(10, 5.0);
        from.set(12, 1.0);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from});
        DoubleSparseVector to = new DoubleSparseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to});
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)from.get(i), (double)to.get(i), (double)E);
        }
    }
}

