/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import org.apache.giraph.aggregators.matrix.dense.LongDenseVector;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestLongDenseMatrix {
    @Test
    public void testVectorSingleton() {
        LongDenseVector vec1 = new LongDenseVector(10);
        vec1.set(0, 1L);
        vec1.set(6, 14L);
        LongDenseVector vec2 = new LongDenseVector();
        vec2.setSingleton(6, 10L);
        vec1.add(vec2);
        Assert.assertEquals((long)24L, (long)vec1.get(6));
        vec2.setSingleton(15, 15L);
        vec1.add(vec2);
        Assert.assertEquals((long)15L, (long)vec1.get(15));
    }

    @Test
    public void testVectorAdd() {
        LongDenseVector vec1 = new LongDenseVector(10);
        Assert.assertEquals((long)0L, (long)vec1.get(0));
        vec1.set(0, 1L);
        vec1.set(6, 14L);
        Assert.assertEquals((long)1L, (long)vec1.get(0));
        Assert.assertEquals((long)0L, (long)vec1.get(4));
        Assert.assertEquals((long)14L, (long)vec1.get(6));
        Assert.assertEquals((long)0L, (long)vec1.get(15));
        LongDenseVector vec2 = new LongDenseVector(20);
        vec2.set(0, 5L);
        vec2.set(5, 17L);
        vec1.add(vec2);
        Assert.assertEquals((long)6L, (long)vec1.get(0));
        Assert.assertEquals((long)17L, (long)vec1.get(5));
        Assert.assertEquals((long)14L, (long)vec1.get(6));
        Assert.assertEquals((long)0L, (long)vec1.get(15));
    }

    @Test
    public void testVectorSerialize() throws Exception {
        int size = 100;
        LongDenseVector from = new LongDenseVector(size);
        from.set(0, 100L);
        from.set(10, 50L);
        from.set(12, 10L);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from, from});
        LongDenseVector to1 = new LongDenseVector();
        LongDenseVector to2 = new LongDenseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to1, to2});
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)from.get(i), (long)to1.get(i));
            Assert.assertEquals((long)from.get(i), (long)to2.get(i));
        }
    }

    @Test
    public void testVectorSerializeSingleton() throws Exception {
        LongDenseVector from = new LongDenseVector();
        from.setSingleton(3, 10L);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from, from});
        LongDenseVector to1 = new LongDenseVector();
        LongDenseVector to2 = new LongDenseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to1, to2});
        Assert.assertEquals((long)from.getSingletonIndex(), (long)to1.getSingletonIndex());
        Assert.assertEquals((long)from.getSingletonIndex(), (long)to2.getSingletonIndex());
        Assert.assertEquals((long)from.getSingletonValue(), (long)to2.getSingletonValue());
        Assert.assertEquals((long)from.getSingletonValue(), (long)to2.getSingletonValue());
    }
}

