/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import org.apache.giraph.aggregators.matrix.dense.IntDenseVector;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestIntDenseMatrix {
    @Test
    public void testVectorSingleton() {
        IntDenseVector vec1 = new IntDenseVector(10);
        vec1.set(0, 0);
        vec1.set(6, 14);
        IntDenseVector vec2 = new IntDenseVector();
        vec2.setSingleton(6, 10);
        vec1.add(vec2);
        Assert.assertEquals((long)24L, (long)vec1.get(6));
        vec2.setSingleton(15, 15);
        vec1.add(vec2);
        Assert.assertEquals((long)15L, (long)vec1.get(15));
    }

    @Test
    public void testVectorAdd() {
        IntDenseVector vec1 = new IntDenseVector(10);
        Assert.assertEquals((long)0L, (long)vec1.get(0));
        vec1.set(0, 1);
        vec1.set(6, 14);
        Assert.assertEquals((long)1L, (long)vec1.get(0));
        Assert.assertEquals((long)0L, (long)vec1.get(4));
        Assert.assertEquals((long)14L, (long)vec1.get(6));
        Assert.assertEquals((long)0L, (long)vec1.get(15));
        IntDenseVector vec2 = new IntDenseVector(20);
        vec2.set(0, 5);
        vec2.set(5, 17);
        vec1.add(vec2);
        Assert.assertEquals((long)6L, (long)vec1.get(0));
        Assert.assertEquals((long)17L, (long)vec1.get(5));
        Assert.assertEquals((long)14L, (long)vec1.get(6));
        Assert.assertEquals((long)0L, (long)vec1.get(15));
    }

    @Test
    public void testVectorSerialize() throws Exception {
        int size = 100;
        IntDenseVector from = new IntDenseVector(size);
        from.set(0, 100);
        from.set(10, 50);
        from.set(12, 10);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from, from});
        IntDenseVector to1 = new IntDenseVector();
        IntDenseVector to2 = new IntDenseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to1, to2});
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)from.get(i), (long)to1.get(i));
            Assert.assertEquals((long)from.get(i), (long)to2.get(i));
        }
    }

    @Test
    public void testVectorSerializeSingleton() throws Exception {
        IntDenseVector from = new IntDenseVector();
        from.setSingleton(3, 100);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from, from});
        IntDenseVector to1 = new IntDenseVector();
        IntDenseVector to2 = new IntDenseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to1, to2});
        Assert.assertEquals((long)from.getSingletonIndex(), (long)to1.getSingletonIndex());
        Assert.assertEquals((long)from.getSingletonIndex(), (long)to2.getSingletonIndex());
        Assert.assertEquals((long)from.getSingletonValue(), (long)to2.getSingletonValue());
        Assert.assertEquals((long)from.getSingletonValue(), (long)to2.getSingletonValue());
    }
}

