/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators.matrix.dense;

import org.apache.giraph.aggregators.matrix.dense.DoubleDenseVector;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestDoubleDenseMatrix {
    private static double E = 1.0E-4f;

    @Test
    public void testVectorSingleton() {
        DoubleDenseVector vec1 = new DoubleDenseVector(10);
        vec1.set(0, 0.1);
        vec1.set(6, 1.4);
        DoubleDenseVector vec2 = new DoubleDenseVector();
        vec2.setSingleton(6, 1.0);
        vec1.add(vec2);
        Assert.assertEquals((double)2.4, (double)vec1.get(6), (double)E);
        vec2.setSingleton(15, 1.5);
        vec1.add(vec2);
        Assert.assertEquals((double)1.5, (double)vec1.get(15), (double)E);
    }

    @Test
    public void testVectorAdd() {
        DoubleDenseVector vec1 = new DoubleDenseVector(10);
        Assert.assertEquals((double)0.0, (double)vec1.get(0), (double)E);
        vec1.set(0, 0.1);
        vec1.set(6, 1.4);
        Assert.assertEquals((double)0.1, (double)vec1.get(0), (double)E);
        Assert.assertEquals((double)0.0, (double)vec1.get(4), (double)E);
        Assert.assertEquals((double)1.4, (double)vec1.get(6), (double)E);
        Assert.assertEquals((double)0.0, (double)vec1.get(15), (double)E);
        DoubleDenseVector vec2 = new DoubleDenseVector(20);
        vec2.set(0, 0.5);
        vec2.set(5, 1.7);
        vec1.add(vec2);
        Assert.assertEquals((double)0.6, (double)vec1.get(0), (double)E);
        Assert.assertEquals((double)1.7, (double)vec1.get(5), (double)E);
        Assert.assertEquals((double)1.4, (double)vec1.get(6), (double)E);
        Assert.assertEquals((double)0.0, (double)vec1.get(15), (double)E);
    }

    @Test
    public void testVectorSerialize() throws Exception {
        int size = 100;
        DoubleDenseVector from = new DoubleDenseVector(size);
        from.set(0, 10.0);
        from.set(10, 5.0);
        from.set(12, 1.0);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from, from});
        DoubleDenseVector to1 = new DoubleDenseVector();
        DoubleDenseVector to2 = new DoubleDenseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to1, to2});
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((double)from.get(i), (double)to1.get(i), (double)E);
            Assert.assertEquals((double)from.get(i), (double)to2.get(i), (double)E);
        }
    }

    @Test
    public void testVectorSerializeSingleton() throws Exception {
        DoubleDenseVector from = new DoubleDenseVector();
        from.setSingleton(3, 10.0);
        byte[] data = WritableUtils.writeToByteArray((Writable[])new Writable[]{from, from});
        DoubleDenseVector to1 = new DoubleDenseVector();
        DoubleDenseVector to2 = new DoubleDenseVector();
        WritableUtils.readFieldsFromByteArray((byte[])data, (Writable[])new Writable[]{to1, to2});
        Assert.assertEquals((long)from.getSingletonIndex(), (long)to1.getSingletonIndex());
        Assert.assertEquals((long)from.getSingletonIndex(), (long)to2.getSingletonIndex());
        Assert.assertEquals((double)from.getSingletonValue(), (double)to2.getSingletonValue(), (double)E);
        Assert.assertEquals((double)from.getSingletonValue(), (double)to2.getSingletonValue(), (double)E);
    }
}

