/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators;

import org.apache.giraph.aggregators.LongMaxAggregator;
import org.apache.giraph.aggregators.LongMinAggregator;
import org.apache.giraph.aggregators.LongOverwriteAggregator;
import org.apache.giraph.aggregators.LongProductAggregator;
import org.apache.giraph.aggregators.LongSumAggregator;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestLongAggregators {
    @Test
    public void testMaxAggregator() {
        LongMaxAggregator max = new LongMaxAggregator();
        max.aggregate(new LongWritable(2L));
        max.aggregate(new LongWritable(3L));
        Assert.assertEquals((long)3L, (long)((LongWritable)max.getAggregatedValue()).get());
        max.setAggregatedValue((Writable)new LongWritable(1L));
        Assert.assertEquals((long)1L, (long)((LongWritable)max.getAggregatedValue()).get());
        LongWritable lw = max.createInitialValue();
        Assert.assertNotNull((Object)lw);
    }

    @Test
    public void testMinAggregator() {
        LongMinAggregator min = new LongMinAggregator();
        min.aggregate(new LongWritable(3L));
        min.aggregate(new LongWritable(2L));
        Assert.assertEquals((long)2L, (long)((LongWritable)min.getAggregatedValue()).get());
        min.setAggregatedValue((Writable)new LongWritable(3L));
        Assert.assertEquals((long)3L, (long)((LongWritable)min.getAggregatedValue()).get());
        LongWritable lw = min.createInitialValue();
        Assert.assertNotNull((Object)lw);
    }

    @Test
    public void testOverwriteAggregator() {
        LongOverwriteAggregator overwrite = new LongOverwriteAggregator();
        overwrite.aggregate(new LongWritable(1L));
        Assert.assertEquals((long)1L, (long)((LongWritable)overwrite.getAggregatedValue()).get());
        overwrite.aggregate(new LongWritable(2L));
        Assert.assertEquals((long)2L, (long)((LongWritable)overwrite.getAggregatedValue()).get());
        overwrite.setAggregatedValue((Writable)new LongWritable(3L));
        Assert.assertEquals((long)3L, (long)((LongWritable)overwrite.getAggregatedValue()).get());
        LongWritable lw = overwrite.createInitialValue();
        Assert.assertNotNull((Object)lw);
    }

    @Test
    public void testProductAggregator() {
        LongProductAggregator product = new LongProductAggregator();
        product.aggregate(new LongWritable(6L));
        product.aggregate(new LongWritable(7L));
        Assert.assertEquals((long)42L, (long)((LongWritable)product.getAggregatedValue()).get());
        product.setAggregatedValue((Writable)new LongWritable(1L));
        Assert.assertEquals((long)1L, (long)((LongWritable)product.getAggregatedValue()).get());
        LongWritable lw = product.createInitialValue();
        Assert.assertNotNull((Object)lw);
    }

    @Test
    public void testSumAggregator() {
        LongSumAggregator sum = new LongSumAggregator();
        sum.aggregate(new LongWritable(1L));
        sum.aggregate(new LongWritable(2L));
        Assert.assertEquals((long)3L, (long)((LongWritable)sum.getAggregatedValue()).get());
        sum.setAggregatedValue((Writable)new LongWritable(4L));
        Assert.assertEquals((long)4L, (long)((LongWritable)sum.getAggregatedValue()).get());
        LongWritable lw = sum.createInitialValue();
        Assert.assertNotNull((Object)lw);
    }
}

