/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators;

import org.apache.giraph.aggregators.IntMaxAggregator;
import org.apache.giraph.aggregators.IntMinAggregator;
import org.apache.giraph.aggregators.IntOverwriteAggregator;
import org.apache.giraph.aggregators.IntProductAggregator;
import org.apache.giraph.aggregators.IntSumAggregator;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestIntAggregators {
    @Test
    public void testMaxAggregator() {
        IntMaxAggregator max = new IntMaxAggregator();
        max.aggregate(new IntWritable(2));
        max.aggregate(new IntWritable(3));
        Assert.assertEquals((long)3L, (long)((IntWritable)max.getAggregatedValue()).get());
        max.setAggregatedValue((Writable)new IntWritable(1));
        Assert.assertEquals((long)1L, (long)((IntWritable)max.getAggregatedValue()).get());
        IntWritable iw = max.createInitialValue();
        Assert.assertNotNull((Object)iw);
    }

    @Test
    public void testMinAggregator() {
        IntMinAggregator min = new IntMinAggregator();
        min.aggregate(new IntWritable(3));
        min.aggregate(new IntWritable(2));
        Assert.assertEquals((long)2L, (long)((IntWritable)min.getAggregatedValue()).get());
        min.setAggregatedValue((Writable)new IntWritable(3));
        Assert.assertEquals((long)3L, (long)((IntWritable)min.getAggregatedValue()).get());
        IntWritable iw = min.createInitialValue();
        Assert.assertNotNull((Object)iw);
    }

    @Test
    public void testOverwriteAggregator() {
        IntOverwriteAggregator overwrite = new IntOverwriteAggregator();
        overwrite.aggregate(new IntWritable(1));
        Assert.assertEquals((long)1L, (long)((IntWritable)overwrite.getAggregatedValue()).get());
        overwrite.aggregate(new IntWritable(2));
        Assert.assertEquals((long)2L, (long)((IntWritable)overwrite.getAggregatedValue()).get());
        overwrite.setAggregatedValue((Writable)new IntWritable(3));
        Assert.assertEquals((long)3L, (long)((IntWritable)overwrite.getAggregatedValue()).get());
        IntWritable iw = overwrite.createInitialValue();
        Assert.assertNotNull((Object)iw);
    }

    @Test
    public void testProductAggregator() {
        IntProductAggregator product = new IntProductAggregator();
        product.aggregate(new IntWritable(6));
        product.aggregate(new IntWritable(7));
        Assert.assertEquals((long)42L, (long)((IntWritable)product.getAggregatedValue()).get());
        product.setAggregatedValue((Writable)new IntWritable(1));
        Assert.assertEquals((long)1L, (long)((IntWritable)product.getAggregatedValue()).get());
        IntWritable iw = product.createInitialValue();
        Assert.assertNotNull((Object)iw);
    }

    @Test
    public void testSumAggregator() {
        IntSumAggregator sum = new IntSumAggregator();
        sum.aggregate(new IntWritable(1));
        sum.aggregate(new IntWritable(2));
        Assert.assertEquals((long)3L, (long)((IntWritable)sum.getAggregatedValue()).get());
        sum.setAggregatedValue((Writable)new IntWritable(4));
        Assert.assertEquals((long)4L, (long)((IntWritable)sum.getAggregatedValue()).get());
        IntWritable iw = sum.createInitialValue();
        Assert.assertNotNull((Object)iw);
    }
}

