/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators;

import org.apache.giraph.aggregators.FloatMaxAggregator;
import org.apache.giraph.aggregators.FloatMinAggregator;
import org.apache.giraph.aggregators.FloatOverwriteAggregator;
import org.apache.giraph.aggregators.FloatProductAggregator;
import org.apache.giraph.aggregators.FloatSumAggregator;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestFloatAggregators {
    @Test
    public void testMaxAggregator() {
        FloatMaxAggregator max = new FloatMaxAggregator();
        max.aggregate(new FloatWritable(2.0f));
        max.aggregate(new FloatWritable(3.0f));
        Assert.assertEquals((float)3.0f, (float)((FloatWritable)max.getAggregatedValue()).get(), (float)0.0f);
        max.setAggregatedValue((Writable)new FloatWritable(1.0f));
        Assert.assertEquals((float)1.0f, (float)((FloatWritable)max.getAggregatedValue()).get(), (float)0.0f);
        FloatWritable fw = max.createInitialValue();
        Assert.assertNotNull((Object)fw);
    }

    @Test
    public void testMinAggregator() {
        FloatMinAggregator min = new FloatMinAggregator();
        min.aggregate(new FloatWritable(3.0f));
        min.aggregate(new FloatWritable(2.0f));
        Assert.assertEquals((float)2.0f, (float)((FloatWritable)min.getAggregatedValue()).get(), (float)0.0f);
        min.setAggregatedValue((Writable)new FloatWritable(3.0f));
        Assert.assertEquals((float)3.0f, (float)((FloatWritable)min.getAggregatedValue()).get(), (float)0.0f);
        FloatWritable fw = min.createInitialValue();
        Assert.assertNotNull((Object)fw);
    }

    @Test
    public void testOverwriteAggregator() {
        FloatOverwriteAggregator overwrite = new FloatOverwriteAggregator();
        overwrite.aggregate(new FloatWritable(1.0f));
        Assert.assertEquals((float)1.0f, (float)((FloatWritable)overwrite.getAggregatedValue()).get(), (float)0.0f);
        overwrite.aggregate(new FloatWritable(2.0f));
        Assert.assertEquals((float)2.0f, (float)((FloatWritable)overwrite.getAggregatedValue()).get(), (float)0.0f);
        overwrite.setAggregatedValue((Writable)new FloatWritable(3.0f));
        Assert.assertEquals((float)3.0f, (float)((FloatWritable)overwrite.getAggregatedValue()).get(), (float)0.0f);
        FloatWritable fw = overwrite.createInitialValue();
        Assert.assertNotNull((Object)fw);
    }

    @Test
    public void testProductAggregator() {
        FloatProductAggregator product = new FloatProductAggregator();
        product.aggregate(new FloatWritable(6.0f));
        product.aggregate(new FloatWritable(7.0f));
        Assert.assertEquals((float)42.0f, (float)((FloatWritable)product.getAggregatedValue()).get(), (float)0.0f);
        product.setAggregatedValue((Writable)new FloatWritable(1.0f));
        Assert.assertEquals((float)1.0f, (float)((FloatWritable)product.getAggregatedValue()).get(), (float)0.0f);
        FloatWritable fw = product.createInitialValue();
        Assert.assertNotNull((Object)fw);
    }

    @Test
    public void testSumAggregator() {
        FloatSumAggregator sum = new FloatSumAggregator();
        sum.aggregate(new FloatWritable(1.0f));
        sum.aggregate(new FloatWritable(2.0f));
        Assert.assertEquals((float)3.0f, (float)((FloatWritable)sum.getAggregatedValue()).get(), (float)0.0f);
        sum.setAggregatedValue((Writable)new FloatWritable(4.0f));
        Assert.assertEquals((float)4.0f, (float)((FloatWritable)sum.getAggregatedValue()).get(), (float)0.0f);
        FloatWritable fw = sum.createInitialValue();
        Assert.assertNotNull((Object)fw);
    }
}

