/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators;

import org.apache.giraph.aggregators.DoubleMaxAggregator;
import org.apache.giraph.aggregators.DoubleMinAggregator;
import org.apache.giraph.aggregators.DoubleOverwriteAggregator;
import org.apache.giraph.aggregators.DoubleProductAggregator;
import org.apache.giraph.aggregators.DoubleSumAggregator;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestDoubleAggregators {
    @Test
    public void testMaxAggregator() {
        DoubleMaxAggregator max = new DoubleMaxAggregator();
        max.aggregate(new DoubleWritable(2.0));
        max.aggregate(new DoubleWritable(3.0));
        Assert.assertEquals((double)3.0, (double)((DoubleWritable)max.getAggregatedValue()).get(), (double)0.0);
        max.setAggregatedValue((Writable)new DoubleWritable(1.0));
        Assert.assertEquals((double)1.0, (double)((DoubleWritable)max.getAggregatedValue()).get(), (double)0.0);
        DoubleWritable dw = max.createInitialValue();
        Assert.assertNotNull((Object)dw);
    }

    @Test
    public void testMinAggregator() {
        DoubleMinAggregator min = new DoubleMinAggregator();
        min.aggregate(new DoubleWritable(3.0));
        min.aggregate(new DoubleWritable(2.0));
        Assert.assertEquals((double)2.0, (double)((DoubleWritable)min.getAggregatedValue()).get(), (double)0.0);
        min.setAggregatedValue((Writable)new DoubleWritable(3.0));
        Assert.assertEquals((double)3.0, (double)((DoubleWritable)min.getAggregatedValue()).get(), (double)0.0);
        DoubleWritable dw = min.createInitialValue();
        Assert.assertNotNull((Object)dw);
    }

    @Test
    public void testOverwriteAggregator() {
        DoubleOverwriteAggregator overwrite = new DoubleOverwriteAggregator();
        overwrite.aggregate(new DoubleWritable(1.0));
        Assert.assertEquals((double)1.0, (double)((DoubleWritable)overwrite.getAggregatedValue()).get(), (double)0.0);
        overwrite.aggregate(new DoubleWritable(2.0));
        Assert.assertEquals((double)2.0, (double)((DoubleWritable)overwrite.getAggregatedValue()).get(), (double)0.0);
        overwrite.setAggregatedValue((Writable)new DoubleWritable(3.0));
        Assert.assertEquals((double)3.0, (double)((DoubleWritable)overwrite.getAggregatedValue()).get(), (double)0.0);
        DoubleWritable dw = overwrite.createInitialValue();
        Assert.assertNotNull((Object)dw);
    }

    @Test
    public void testProductAggregator() {
        DoubleProductAggregator product = new DoubleProductAggregator();
        product.aggregate(new DoubleWritable(6.0));
        product.aggregate(new DoubleWritable(7.0));
        Assert.assertEquals((double)42.0, (double)((DoubleWritable)product.getAggregatedValue()).get(), (double)0.0);
        product.setAggregatedValue((Writable)new DoubleWritable(1.0));
        Assert.assertEquals((double)1.0, (double)((DoubleWritable)product.getAggregatedValue()).get(), (double)0.0);
        DoubleWritable dw = product.createInitialValue();
        Assert.assertNotNull((Object)dw);
    }

    @Test
    public void testSumAggregator() {
        DoubleSumAggregator sum = new DoubleSumAggregator();
        sum.aggregate(new DoubleWritable(1.0));
        sum.aggregate(new DoubleWritable(2.0));
        Assert.assertEquals((double)3.0, (double)((DoubleWritable)sum.getAggregatedValue()).get(), (double)0.0);
        sum.setAggregatedValue((Writable)new DoubleWritable(4.0));
        Assert.assertEquals((double)4.0, (double)((DoubleWritable)sum.getAggregatedValue()).get(), (double)0.0);
        DoubleWritable dw = sum.createInitialValue();
        Assert.assertNotNull((Object)dw);
    }
}

