/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.aggregators;

import org.apache.giraph.aggregators.BooleanAndAggregator;
import org.apache.giraph.aggregators.BooleanOrAggregator;
import org.apache.giraph.aggregators.BooleanOverwriteAggregator;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Test;

public class TestBooleanAggregators {
    @Test
    public void testAndAggregator() {
        BooleanAndAggregator and = new BooleanAndAggregator();
        Assert.assertEquals((Object)true, (Object)((BooleanWritable)and.getAggregatedValue()).get());
        and.aggregate(new BooleanWritable(true));
        Assert.assertEquals((Object)true, (Object)((BooleanWritable)and.getAggregatedValue()).get());
        and.aggregate(new BooleanWritable(false));
        Assert.assertEquals((Object)false, (Object)((BooleanWritable)and.getAggregatedValue()).get());
        and.setAggregatedValue((Writable)new BooleanWritable(true));
        Assert.assertEquals((Object)true, (Object)((BooleanWritable)and.getAggregatedValue()).get());
        BooleanWritable bw = and.createInitialValue();
        Assert.assertNotNull((Object)bw);
    }

    @Test
    public void testOrAggregator() {
        BooleanOrAggregator or = new BooleanOrAggregator();
        Assert.assertEquals((Object)false, (Object)((BooleanWritable)or.getAggregatedValue()).get());
        or.aggregate(new BooleanWritable(false));
        Assert.assertEquals((Object)false, (Object)((BooleanWritable)or.getAggregatedValue()).get());
        or.aggregate(new BooleanWritable(true));
        Assert.assertEquals((Object)true, (Object)((BooleanWritable)or.getAggregatedValue()).get());
        or.setAggregatedValue((Writable)new BooleanWritable(false));
        Assert.assertEquals((Object)false, (Object)((BooleanWritable)or.getAggregatedValue()).get());
        BooleanWritable bw = or.createInitialValue();
        Assert.assertNotNull((Object)bw);
    }

    @Test
    public void testOverwriteAggregator() {
        BooleanOverwriteAggregator overwrite = new BooleanOverwriteAggregator();
        overwrite.aggregate(new BooleanWritable(true));
        Assert.assertEquals((Object)true, (Object)((BooleanWritable)overwrite.getAggregatedValue()).get());
        overwrite.aggregate(new BooleanWritable(false));
        Assert.assertEquals((Object)false, (Object)((BooleanWritable)overwrite.getAggregatedValue()).get());
        overwrite.setAggregatedValue((Writable)new BooleanWritable(true));
        Assert.assertEquals((Object)true, (Object)((BooleanWritable)overwrite.getAggregatedValue()).get());
        BooleanWritable bw = overwrite.createInitialValue();
        Assert.assertNotNull((Object)bw);
    }
}

