/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.job.GiraphJob;
import org.apache.giraph.utils.FileUtils;
import org.apache.giraph.zk.ZooKeeperExt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.junit.After;
import org.junit.Before;

public class BspCase
implements Watcher {
    private final String jobTracker = System.getProperty("prop.mapred.job.tracker");
    private final String jarLocation = System.getProperty("prop.jarLocation", "");
    private int numWorkers = 1;
    private final String zkList = System.getProperty("prop.zookeeper.list");
    private String testName;
    static final Path DEFAULT_TEMP_DIR = new Path(System.getProperty("java.io.tmpdir"), "_giraphTests");
    public static final String READER_VERTICES_OPT = "GeneratedVertexReader.reader_vertices";
    static final PathFilter PARTS_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            return path.getName().startsWith("part-");
        }
    };

    public final Configuration setupConfiguration(GiraphJob job) throws IOException {
        GiraphConfiguration conf = job.getConfiguration();
        conf.set("mapred.jar", this.getJarLocation());
        if (this.runningInDistributedMode()) {
            System.out.println("setupConfiguration: Sending job to job tracker " + this.jobTracker + " with jar path " + this.getJarLocation() + " for " + this.getName());
            conf.set("mapred.job.tracker", this.jobTracker);
            conf.setWorkerConfiguration(this.getNumWorkers(), this.getNumWorkers(), 100.0f);
        } else {
            System.out.println("setupConfiguration: Using local job runner with location " + this.getJarLocation() + " for " + this.getName());
            conf.setWorkerConfiguration(1, 1, 100.0f);
            GiraphConstants.SPLIT_MASTER_WORKER.set((Configuration)conf, false);
            GiraphConstants.LOCAL_TEST_MODE.set((Configuration)conf, true);
        }
        conf.setMaxMasterSuperstepWaitMsecs(30000);
        conf.setEventWaitMsecs(3000);
        GiraphConstants.ZOOKEEPER_SERVERLIST_POLL_MSECS.set((Configuration)conf, 500);
        if (this.getZooKeeperList() != null) {
            conf.setZooKeeperConfiguration(this.getZooKeeperList());
        }
        conf.setLong(READER_VERTICES_OPT, 5L);
        Path zookeeperDir = this.getTempPath("_bspZooKeeper");
        Path zkManagerDir = this.getTempPath("_defaultZkManagerDir");
        Path checkPointDir = this.getTempPath("_checkpoints");
        FileUtils.deletePath((Configuration)conf, (Path)zookeeperDir);
        FileUtils.deletePath((Configuration)conf, (Path)zkManagerDir);
        FileUtils.deletePath((Configuration)conf, (Path)checkPointDir);
        conf.set("giraph.zkDir", zookeeperDir.toString());
        GiraphConstants.ZOOKEEPER_MANAGER_DIRECTORY.set((Configuration)conf, zkManagerDir.toString());
        GiraphConstants.CHECKPOINT_DIRECTORY.set((Configuration)conf, checkPointDir.toString());
        return conf;
    }

    protected Path getTempPath(String name) {
        return new Path(DEFAULT_TEMP_DIR, name);
    }

    protected GiraphJob prepareJob(String name, GiraphConfiguration conf) throws IOException {
        return this.prepareJob(name, conf, null);
    }

    protected GiraphJob prepareJob(String name, GiraphConfiguration conf, Path outputPath) throws IOException {
        GiraphJob job = new GiraphJob(conf, name);
        this.setupConfiguration(job);
        if (outputPath != null) {
            BspCase.removeAndSetOutput(job, outputPath);
        }
        return job;
    }

    private String getName() {
        return this.testName;
    }

    public BspCase(String testName) {
        this.testName = testName;
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public String getZooKeeperList() {
        return this.zkList;
    }

    String getJarLocation() {
        return this.jarLocation;
    }

    public boolean runningInDistributedMode() {
        return this.jobTracker != null;
    }

    public static FileStatus getSinglePartFileStatus(Configuration conf, Path partDirPath) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus singlePartFileStatus = null;
        int partFiles = 0;
        for (FileStatus fileStatus : fs.listStatus(partDirPath)) {
            if (fileStatus.getPath().getName().equals("part-m-00000")) {
                singlePartFileStatus = fileStatus;
            }
            if (!fileStatus.getPath().getName().startsWith("part-m-")) continue;
            ++partFiles;
        }
        Preconditions.checkState((partFiles == 1 ? 1 : 0) != 0, (Object)("getSinglePartFile: Part file count should be 1, but is " + partFiles));
        return singlePartFileStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumResults(Configuration conf, Path outputPath) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        int numResults = 0;
        for (FileStatus status : fs.listStatus(outputPath, PARTS_FILTER)) {
            FSDataInputStream in = null;
            BufferedReader reader = null;
            try {
                in = fs.open(status.getPath());
                reader = new BufferedReader(new InputStreamReader((InputStream)in, Charsets.UTF_8));
                while (reader.readLine() != null) {
                    ++numResults;
                }
            }
            catch (Throwable throwable) {
                Closeables.close((Closeable)in, (boolean)true);
                Closeables.close(reader, (boolean)true);
                throw throwable;
            }
            Closeables.close((Closeable)in, (boolean)true);
            Closeables.close((Closeable)reader, (boolean)true);
        }
        return numResults;
    }

    @Before
    public void setUp() {
        if (this.runningInDistributedMode()) {
            System.out.println("setUp: Setting tasks to 3 for " + this.getName() + " since JobTracker exists...");
            this.numWorkers = 3;
        }
        try {
            this.cleanupTemporaryFiles();
            if (this.zkList == null) {
                return;
            }
            ZooKeeperExt zooKeeperExt = new ZooKeeperExt(this.zkList, 30000, 0, 0, (Watcher)this);
            List rootChildren = zooKeeperExt.getChildrenExt("/", false, false, true);
            for (String rootChild : rootChildren) {
                if (!rootChild.startsWith("/_hadoopBsp")) continue;
                List children = zooKeeperExt.getChildrenExt(rootChild, false, false, true);
                for (String child : children) {
                    if (!child.contains("job_local_")) continue;
                    System.out.println("Cleaning up " + child);
                    zooKeeperExt.deleteExt(child, -1, true);
                }
            }
            zooKeeperExt.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @After
    public void tearDown() throws IOException {
        this.cleanupTemporaryFiles();
    }

    private void cleanupTemporaryFiles() throws IOException {
        FileUtils.deletePath((Configuration)new Configuration(), (Path)DEFAULT_TEMP_DIR);
    }

    public void process(WatchedEvent event) {
    }

    public static void removeAndSetOutput(GiraphJob job, Path outputPath) throws IOException {
        FileUtils.deletePath((Configuration)job.getConfiguration(), (Path)outputPath);
        FileOutputFormat.setOutputPath((Job)job.getInternalJob(), (Path)outputPath);
    }

    public static String getCallingMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }
}

