/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.examples.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class BrachaTouegDeadlockVertexValue
implements Writable {
    public static final Long INVALID_ID = -1L;
    private boolean isFree = false;
    private boolean isNotified = false;
    private HashMap<Long, ArrayList<Long>> requests;
    private HashMap<Long, Long> waitingList;
    private ArrayList<Long> parents;
    private Long idWithInHoldAck;
    private Long idWithInHoldDone;

    public BrachaTouegDeadlockVertexValue() {
        this(new HashMap<Long, ArrayList<Long>>());
    }

    public BrachaTouegDeadlockVertexValue(HashMap<Long, ArrayList<Long>> requests) {
        this.requests = requests;
        this.waitingList = new HashMap();
        this.parents = new ArrayList();
        this.idWithInHoldAck = INVALID_ID;
        this.idWithInHoldDone = INVALID_ID;
    }

    public void readFields(DataInput input) throws IOException {
        int i;
        this.isFree = input.readBoolean();
        this.isNotified = input.readBoolean();
        int sz = input.readInt();
        for (i = 0; i < sz; ++i) {
            ArrayList<Long> targets = new ArrayList<Long>();
            Long tag = input.readLong();
            int sw = input.readInt();
            for (int j = 0; j < sw; ++j) {
                Long target = input.readLong();
                targets.add(target);
            }
            this.requests.put(tag, targets);
        }
        sz = input.readInt();
        for (i = 0; i < sz; ++i) {
            Long key = input.readLong();
            Long value = input.readLong();
            this.waitingList.put(key, value);
        }
        sz = input.readInt();
        for (i = 0; i < sz; ++i) {
            this.parents.add(input.readLong());
        }
        this.idWithInHoldAck = input.readLong();
        this.idWithInHoldDone = input.readLong();
    }

    public void write(DataOutput output) throws IOException {
        output.writeBoolean(this.isFree);
        output.writeBoolean(this.isNotified);
        int sz = this.requests.size();
        output.writeInt(sz);
        for (Map.Entry<Long, ArrayList<Long>> entry : this.requests.entrySet()) {
            output.writeLong(entry.getKey());
            ArrayList<Long> targets = entry.getValue();
            sz = targets.size();
            output.writeInt(sz);
            for (Long target : targets) {
                output.writeLong(target);
            }
        }
        sz = this.waitingList.size();
        output.writeInt(sz);
        for (Map.Entry<Long, Serializable> entry : this.waitingList.entrySet()) {
            output.writeLong(entry.getKey());
            output.writeLong((Long)entry.getValue());
        }
        sz = this.parents.size();
        output.writeInt(sz);
        for (int i = 0; i < sz; ++i) {
            output.writeLong(this.parents.get(i));
        }
        output.writeLong(this.idWithInHoldAck);
        output.writeLong(this.idWithInHoldDone);
    }

    public boolean isFree() {
        return this.isFree;
    }

    public void setFree() {
        this.isFree = true;
    }

    public boolean isNotified() {
        return this.isNotified;
    }

    public void setNotified() {
        this.isNotified = true;
    }

    public boolean hasPendingRequests() {
        boolean withPendingRequests = true;
        if (this.requests.isEmpty()) {
            withPendingRequests = false;
        }
        for (Map.Entry<Long, ArrayList<Long>> request : this.requests.entrySet()) {
            ArrayList<Long> targets = request.getValue();
            if (targets.size() != 0) continue;
            withPendingRequests = false;
        }
        return withPendingRequests;
    }

    public void removeRequest(LongWritable tag, LongWritable targetId) {
        Long l = tag.get();
        ArrayList<Long> targets = this.requests.get(l);
        if (targets.contains(targetId.get())) {
            targets.remove(targetId.get());
        }
    }

    public int getNumOfRequests(LongWritable tag) {
        Long l = tag.get();
        ArrayList<Long> targets = this.requests.get(l);
        return targets.size();
    }

    public void waitForMessage(Long id, Long type) {
        assert (this.waitingList.get(id) == null);
        this.waitingList.put(id, type);
    }

    public void receivedMessage(Long id, Long type) {
        assert (this.waitingList.get(id) != null);
        long typel = this.waitingList.get(id);
        assert (typel > 0L);
        this.waitingList.remove(id);
    }

    public boolean isWaitingForMessage(Long type) {
        for (Map.Entry<Long, Long> entry : this.waitingList.entrySet()) {
            long typel = entry.getValue();
            if ((typel & type) <= 0L) continue;
            return true;
        }
        return false;
    }

    public void addParent(Long parentId) {
        this.parents.add(parentId);
    }

    public ArrayList<Long> getParents() {
        return this.parents;
    }

    public Long getIdWithInHoldAck() {
        return this.idWithInHoldAck;
    }

    public void setIdWithInHoldAck(Long id) {
        this.idWithInHoldAck = id;
    }

    public Long getIdWithInHoldDone() {
        return this.idWithInHoldDone;
    }

    public void setIdWithInHoldDone(Long doneId) {
        this.idWithInHoldDone = doneId;
    }

    public String toString() {
        return "isFree=" + Boolean.toString(this.isFree);
    }
}

